/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.container.Openable;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.IdentifiableEntry;
import io.github.pronze.lib.simpleinventories.inventory.Insert;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.operations.OperationParser;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import io.github.pronze.lib.simpleinventories.placeholders.PagePlaceholderParser;
import io.github.pronze.lib.simpleinventories.placeholders.ThisPlaceholderParser;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InventorySet
implements Openable {
    private boolean genericShop = false;
    private boolean genericShopPriceTypeRequired = true;
    private boolean animationsEnabled = false;
    private boolean allowAccessToConsole = false;
    private boolean allowBungeecordPlayerSending = false;
    private final EventManager eventManager = EventManager.createChildManager();
    private final Map<String, IPlaceholderParser> placeholders = new HashMap<String, IPlaceholderParser>();
    private final Map<String, IdentifiableEntry> ids = new HashMap<String, IdentifiableEntry>();
    private final Map<String, String> variableToPropertyMap = new HashMap<String, String>();
    private final SubInventory mainSubInventory = new SubInventory(true, null, this);
    private final Deque<Insert> insertQueue = new LinkedList<Insert>();

    public boolean registerPlaceholder(String name, String value) {
        return this.registerPlaceholder(name, (String a, PlayerWrapper b, PlayerItemInfo c, String[] d) -> value);
    }

    public boolean registerPlaceholder(String name, IPlaceholderParser parser) {
        if (name.contains(".") || name.contains(":") || name.contains("%") || name.contains(" ")) {
            return false;
        }
        this.placeholders.put(name, parser);
        return true;
    }

    public Component processPlaceholders(PlayerWrapper player, Component text, PlayerItemInfo info) {
        return AdventureHelper.toComponent(this.processPlaceholders(player, AdventureHelper.toLegacy(text), info));
    }

    public String processPlaceholders(PlayerWrapper player, String text, PlayerItemInfo info) {
        char[] characters = text.toCharArray();
        int lastEscapeIndex = -2;
        Object buf = "";
        for (int i = 0; i < characters.length; ++i) {
            char c = characters[i];
            if (c == '{' && lastEscapeIndex != i - 1) {
                int bracketEnd = characters.length;
                int alastEscapeIndex = -2;
                Object bracketBuf = "";
                for (int j = i + 1; j < characters.length; ++j) {
                    char cc = characters[j];
                    if (cc == '\\' && alastEscapeIndex != j - 1) {
                        alastEscapeIndex = j;
                        continue;
                    }
                    if (cc == '}' && alastEscapeIndex != j - 1) {
                        bracketEnd = j;
                        break;
                    }
                    bracketBuf = (String)bracketBuf + cc;
                }
                i = bracketEnd;
                buf = (String)buf + String.valueOf(OperationParser.getFinalOperation(this, (String)bracketBuf).resolveFor(player, info));
                continue;
            }
            if (c == '\\' && lastEscapeIndex != i - 1) {
                lastEscapeIndex = i;
                continue;
            }
            buf = (String)buf + c;
        }
        text = buf;
        Pattern pat = Pattern.compile("%[^%]+%");
        Matcher matcher = pat.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String matched = matcher.group();
            matched = matcher.group().substring(1, matched.length() - 1);
            String[] args = matched.split("(?<!\\.)\\.(?!\\.)");
            String[] gargs = new String[args.length - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].replaceAll("\\.+", ".");
                if (i <= 0) continue;
                gargs[i - 1] = args[i];
            }
            String key = args[0];
            if (!this.placeholders.containsKey(key)) continue;
            matcher.appendReplacement(sb, this.placeholders.get(key).processPlaceholder(key, player, info, gargs));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Optional<GenericItemInfo> resolveItemLink(String link) {
        IdentifiableEntry itemInfoLike;
        if ((link.startsWith("$") || link.startsWith("\u00a7")) && (itemInfoLike = this.ids.get(link.substring(1))) instanceof GenericItemInfo) {
            return Optional.of((GenericItemInfo)itemInfoLike);
        }
        return Optional.empty();
    }

    public Optional<IdentifiableEntry> resolveIdentifiableEntry(String link) {
        if (link.startsWith("$") || link.startsWith("\u00a7")) {
            return Optional.ofNullable(this.ids.get(link.substring(1)));
        }
        return Optional.empty();
    }

    public Optional<SubInventory> resolveCategoryLink(String link) {
        if (link.equalsIgnoreCase("main")) {
            return Optional.of(this.mainSubInventory);
        }
        Optional<IdentifiableEntry> itemOpt = this.resolveIdentifiableEntry(link);
        if (itemOpt.isPresent()) {
            IdentifiableEntry itemInfo = itemOpt.get();
            if (!itemInfo.hasChildInventory()) {
                itemInfo.setChildInventory(new SubInventory(false, itemInfo, itemInfo.getFormat()));
            }
            return Optional.of(itemInfo.getChildInventory());
        }
        return Optional.empty();
    }

    @Override
    public void openInventory(PlayerWrapper wrapper) {
        this.mainSubInventory.openInventory(wrapper);
    }

    public InventorySet() {
        ThisPlaceholderParser thisPlaceholder = new ThisPlaceholderParser();
        this.placeholders.put("this", thisPlaceholder);
        this.placeholders.put("self", thisPlaceholder);
        this.placeholders.put("page", new PagePlaceholderParser());
        SimpleInventoriesCore.registerPlatformSpecificPlaceholders(this.placeholders);
    }

    public boolean isGenericShop() {
        return this.genericShop;
    }

    public boolean isGenericShopPriceTypeRequired() {
        return this.genericShopPriceTypeRequired;
    }

    public boolean isAnimationsEnabled() {
        return this.animationsEnabled;
    }

    public boolean isAllowAccessToConsole() {
        return this.allowAccessToConsole;
    }

    public boolean isAllowBungeecordPlayerSending() {
        return this.allowBungeecordPlayerSending;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Map<String, IPlaceholderParser> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, IdentifiableEntry> getIds() {
        return this.ids;
    }

    public Map<String, String> getVariableToPropertyMap() {
        return this.variableToPropertyMap;
    }

    public SubInventory getMainSubInventory() {
        return this.mainSubInventory;
    }

    public Deque<Insert> getInsertQueue() {
        return this.insertQueue;
    }

    public void setGenericShop(boolean genericShop) {
        this.genericShop = genericShop;
    }

    public void setGenericShopPriceTypeRequired(boolean genericShopPriceTypeRequired) {
        this.genericShopPriceTypeRequired = genericShopPriceTypeRequired;
    }

    public void setAnimationsEnabled(boolean animationsEnabled) {
        this.animationsEnabled = animationsEnabled;
    }

    public void setAllowAccessToConsole(boolean allowAccessToConsole) {
        this.allowAccessToConsole = allowAccessToConsole;
    }

    public void setAllowBungeecordPlayerSending(boolean allowBungeecordPlayerSending) {
        this.allowBungeecordPlayerSending = allowBungeecordPlayerSending;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventorySet)) {
            return false;
        }
        InventorySet other = (InventorySet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGenericShop() != other.isGenericShop()) {
            return false;
        }
        if (this.isGenericShopPriceTypeRequired() != other.isGenericShopPriceTypeRequired()) {
            return false;
        }
        if (this.isAnimationsEnabled() != other.isAnimationsEnabled()) {
            return false;
        }
        if (this.isAllowAccessToConsole() != other.isAllowAccessToConsole()) {
            return false;
        }
        if (this.isAllowBungeecordPlayerSending() != other.isAllowBungeecordPlayerSending()) {
            return false;
        }
        EventManager this$eventManager = this.getEventManager();
        EventManager other$eventManager = other.getEventManager();
        if (this$eventManager == null ? other$eventManager != null : !this$eventManager.equals(other$eventManager)) {
            return false;
        }
        Map<String, IPlaceholderParser> this$placeholders = this.getPlaceholders();
        Map<String, IPlaceholderParser> other$placeholders = other.getPlaceholders();
        if (this$placeholders == null ? other$placeholders != null : !((Object)this$placeholders).equals(other$placeholders)) {
            return false;
        }
        Map<String, IdentifiableEntry> this$ids = this.getIds();
        Map<String, IdentifiableEntry> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        Map<String, String> this$variableToPropertyMap = this.getVariableToPropertyMap();
        Map<String, String> other$variableToPropertyMap = other.getVariableToPropertyMap();
        if (this$variableToPropertyMap == null ? other$variableToPropertyMap != null : !((Object)this$variableToPropertyMap).equals(other$variableToPropertyMap)) {
            return false;
        }
        SubInventory this$mainSubInventory = this.getMainSubInventory();
        SubInventory other$mainSubInventory = other.getMainSubInventory();
        if (this$mainSubInventory == null ? other$mainSubInventory != null : !((Object)this$mainSubInventory).equals(other$mainSubInventory)) {
            return false;
        }
        Deque<Insert> this$insertQueue = this.getInsertQueue();
        Deque<Insert> other$insertQueue = other.getInsertQueue();
        return !(this$insertQueue == null ? other$insertQueue != null : !this$insertQueue.equals(other$insertQueue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventorySet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGenericShop() ? 79 : 97);
        result = result * 59 + (this.isGenericShopPriceTypeRequired() ? 79 : 97);
        result = result * 59 + (this.isAnimationsEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllowAccessToConsole() ? 79 : 97);
        result = result * 59 + (this.isAllowBungeecordPlayerSending() ? 79 : 97);
        EventManager $eventManager = this.getEventManager();
        result = result * 59 + ($eventManager == null ? 43 : $eventManager.hashCode());
        Map<String, IPlaceholderParser> $placeholders = this.getPlaceholders();
        result = result * 59 + ($placeholders == null ? 43 : ((Object)$placeholders).hashCode());
        Map<String, IdentifiableEntry> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        Map<String, String> $variableToPropertyMap = this.getVariableToPropertyMap();
        result = result * 59 + ($variableToPropertyMap == null ? 43 : ((Object)$variableToPropertyMap).hashCode());
        SubInventory $mainSubInventory = this.getMainSubInventory();
        result = result * 59 + ($mainSubInventory == null ? 43 : ((Object)$mainSubInventory).hashCode());
        Deque<Insert> $insertQueue = this.getInsertQueue();
        result = result * 59 + ($insertQueue == null ? 43 : $insertQueue.hashCode());
        return result;
    }

    public String toString() {
        return "InventorySet(genericShop=" + this.isGenericShop() + ", genericShopPriceTypeRequired=" + this.isGenericShopPriceTypeRequired() + ", animationsEnabled=" + this.isAnimationsEnabled() + ", allowAccessToConsole=" + this.isAllowAccessToConsole() + ", allowBungeecordPlayerSending=" + this.isAllowBungeecordPlayerSending() + ", eventManager=" + this.getEventManager() + ", placeholders=" + this.getPlaceholders() + ", ids=" + this.getIds() + ", variableToPropertyMap=" + this.getVariableToPropertyMap() + ", mainSubInventory=" + this.getMainSubInventory() + ")";
    }
}

