/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.Property;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlayerItemInfo {
    private GenericItemInfo original;
    private Item stack;
    private boolean visible;
    private boolean disabled;
    private final List<Item> animation = new ArrayList<Item>();
    private PlayerWrapper player;

    public PlayerItemInfo(PlayerWrapper player, GenericItemInfo original) {
        this.player = player;
        this.original = original;
        this.stack = original.getItem() != null ? original.getItem().clone() : ItemFactory.getAir();
        this.visible = original.isVisible();
        this.disabled = original.isDisabled();
        original.getAnimation().stream().map(Item::clone).forEach(this.animation::add);
        if (this.stack.getDisplayName() != null) {
            this.stack = this.stack.withDisplayName(original.getFormat().processPlaceholders(player, this.stack.getDisplayName(), this));
        }
        if (!this.stack.getLore().isEmpty()) {
            this.stack = this.stack.withItemLore(this.stack.getLore().stream().map(e -> original.getFormat().processPlaceholders(player, (Component)e, this)).collect(Collectors.toList()));
        }
        original.getEventManager().fireEvent(new ItemRenderEvent(this));
    }

    public String getId() {
        return this.original.getId();
    }

    public int getPosition() {
        return this.original.getPosition();
    }

    public List<Property> getProperties() {
        return this.original.getProperties();
    }

    public boolean hasId() {
        return this.original.hasId();
    }

    public boolean hasProperties() {
        return this.original.hasProperties();
    }

    public boolean hasAnimation() {
        return !this.animation.isEmpty();
    }

    public boolean hasChildInventory() {
        return this.original.hasChildInventory();
    }

    public SubInventory getChildInventory() {
        return this.original.getChildInventory();
    }

    public InventorySet getFormat() {
        return this.original.getFormat();
    }

    public SubInventory getParent() {
        return this.original.getParent();
    }

    public Stream<Property> getPropertiesByName(String name) {
        return this.original.getPropertiesByName(name);
    }

    public Optional<Property> getFirstPropertyByName(String name) {
        return this.original.getFirstPropertyByName(name);
    }

    public GenericItemInfo getOriginal() {
        return this.original;
    }

    public Item getStack() {
        return this.stack;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<Item> getAnimation() {
        return this.animation;
    }

    public void setOriginal(GenericItemInfo original) {
        this.original = original;
    }

    public void setStack(Item stack) {
        this.stack = stack;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setPlayer(PlayerWrapper player) {
        this.player = player;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerItemInfo)) {
            return false;
        }
        PlayerItemInfo other = (PlayerItemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        GenericItemInfo this$original = this.getOriginal();
        GenericItemInfo other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !((Object)this$original).equals(other$original)) {
            return false;
        }
        Item this$stack = this.getStack();
        Item other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        List<Item> this$animation = this.getAnimation();
        List<Item> other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        PlayerWrapper this$player = this.getPlayer();
        PlayerWrapper other$player = other.getPlayer();
        return !(this$player == null ? other$player != null : !this$player.equals(other$player));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerItemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        GenericItemInfo $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : ((Object)$original).hashCode());
        Item $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        List<Item> $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        PlayerWrapper $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerItemInfo(original=" + this.getOriginal() + ", stack=" + this.getStack() + ", visible=" + this.isVisible() + ", disabled=" + this.isDisabled() + ", animation=" + this.getAnimation() + ", player=" + this.getPlayer() + ")";
    }

    public PlayerWrapper getPlayer() {
        return this.player;
    }
}

