/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.screaminglib.container.Openable;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.inventory.Clone;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.IdentifiableEntry;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.Insert;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.LocalOptions;
import io.github.pronze.lib.simpleinventories.inventory.Position;
import io.github.pronze.lib.simpleinventories.inventory.Queueable;
import io.github.pronze.lib.simpleinventories.inventory.SubInventoryLike;
import io.github.pronze.lib.simpleinventories.render.InventoryRenderer;
import io.github.pronze.lib.simpleinventories.utils.Column;
import io.github.pronze.lib.simpleinventories.utils.TimesFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubInventory
implements Openable,
SubInventoryLike<SubInventory> {
    private final boolean main;
    @Nullable
    private final IdentifiableEntry itemOwner;
    @NotNull
    @NonNull
    private InventorySet inventorySet;
    private final LocalOptions localOptions = new LocalOptions();
    private int cursorPosition = 0;
    private GenericItemInfo lastItem;
    private final List<GenericItemInfo> contents = new ArrayList<GenericItemInfo>();
    private final Queue<Queueable> waitingQueue = new LinkedList<Queueable>();

    public boolean acceptsLink(String link) {
        if (this.main && link.equalsIgnoreCase("main")) {
            return true;
        }
        return this.itemOwner != null && (link.startsWith("$") || link.startsWith("\u00a7")) && link.substring(1).equals(this.itemOwner.getId());
    }

    public LocalOptions getLocalOptions() {
        if (!this.main && this.itemOwner.getParent() != null) {
            this.localOptions.setParent(this.itemOwner.getParent().getLocalOptions());
        } else {
            this.localOptions.setParent(null);
        }
        return this.localOptions;
    }

    public int getHighestPage() {
        return this.contents.stream().mapToInt(item -> item.getPosition() / this.getLocalOptions().getItemsOnPage()).distinct().max().orElse(0);
    }

    public SubInventory process() {
        List.copyOf(this.inventorySet.getInsertQueue()).stream().filter(Objects::nonNull).filter(i -> this.acceptsLink(i.getLink())).forEach(insert -> {
            this.inventorySet.getInsertQueue().remove(insert);
            insert.getTemporaryInventory().getQueue().stream().map(e -> {
                if (e instanceof GenericItemInfo) {
                    return ((GenericItemInfo)e).clone();
                }
                return e;
            }).forEach(this::process);
        });
        return this.process(this.waitingQueue);
    }

    public SubInventory process(Queue<Queueable> queue) {
        while (!queue.isEmpty()) {
            this.process(queue.remove());
        }
        this.forceReload();
        return this;
    }

    private void process(Queueable object) {
        if (object instanceof Insert) {
            Insert insert = (Insert)object;
            Optional<SubInventory> linkedInventory = this.inventorySet.resolveCategoryLink(insert.getLink());
            linkedInventory.ifPresentOrElse(subInventory -> {
                LinkedList<Queueable> clone = new LinkedList<Queueable>();
                insert.getTemporaryInventory().getQueue().stream().map(e -> {
                    if (e instanceof GenericItemInfo) {
                        return ((GenericItemInfo)e).clone();
                    }
                    return e;
                }).forEach(clone::add);
                subInventory.process(clone);
            }, () -> this.inventorySet.getInsertQueue().add(insert));
        } else if (object instanceof Include) {
            ((Include)object).apply(this);
        } else if (object instanceof IdentifiableEntry) {
            if (object instanceof GenericItemInfo) {
                int times;
                GenericItemInfo item = (GenericItemInfo)object;
                item.setParent(this);
                if (item.getRequestedClone() != null) {
                    Clone clone = item.getRequestedClone();
                    if (clone.getCloneLink().equalsIgnoreCase("cosmetic")) {
                        if (clone.getCloneMethod().isOverride() || item.getItem() == null || item.getItem().getMaterial().equals(ItemFactory.getAir().getMaterial())) {
                            item.setItem(this.getLocalOptions().getCosmeticItem());
                        }
                    } else {
                        GenericItemInfo originalItem = clone.getCloneLink().equalsIgnoreCase("previous") ? this.lastItem : (GenericItemInfo)this.inventorySet.resolveItemLink(clone.getCloneLink()).orElse(null);
                        clone.cloneInto(originalItem, item);
                    }
                }
                if (item.hasId()) {
                    this.inventorySet.getIds().put(item.getId(), item);
                }
                if (item.isWritten()) {
                    int newPosition = this.cursorPosition;
                    if (item.getRequestedPosition() != null) {
                        newPosition = item.getRequestedPosition().calculateThatPosition(newPosition, this.getLocalOptions().getItemsOnRow(), this.getLocalOptions().getRows());
                    }
                    item.setPosition(newPosition);
                    newPosition = item.getRequestedPosition() != null ? item.getRequestedPosition().calculateNextPosition(newPosition, this.getLocalOptions().getItemsOnRow(), this.getLocalOptions().getRows()) : ++newPosition;
                    this.cursorPosition = newPosition;
                    this.contents.stream().filter(genericItemInfo -> genericItemInfo.getPosition() == item.getPosition()).findFirst().ifPresent(genericItemInfo -> {
                        this.contents.remove(genericItemInfo);
                        if (genericItemInfo.hasId()) {
                            this.inventorySet.getIds().remove(genericItemInfo.getId());
                        }
                    });
                }
                this.contents.add(item);
                this.lastItem = item;
                if (item.hasChildInventory()) {
                    item.getChildInventory().process();
                }
                if (item.getRequestedTimes() != null && (times = item.getRequestedTimes().getRepeat()) > 1) {
                    GenericItemInfo clone = item.clone();
                    clone.getRequestedTimes().setRepeat(times - 1);
                    if (item.getRequestedTimes().getFlags().contains((Object)TimesFlags.NO_ID)) {
                        clone.setId(null);
                    }
                    if (item.getRequestedTimes().getFlags().contains((Object)TimesFlags.CANCEL_POSITIONING)) {
                        clone.setRequestedPosition(new Position());
                    }
                    this.process(clone);
                }
            } else {
                IdentifiableEntry category = (IdentifiableEntry)object;
                if (category.getId() == null) {
                    throw new RuntimeException("Hidden category must have an ID!");
                }
                category.setParent(this);
                this.inventorySet.getIds().put(category.getId(), category);
                if (category.hasChildInventory()) {
                    category.getChildInventory().process();
                }
            }
        } else {
            throw new RuntimeException("Invalid object in queue!");
        }
    }

    @Override
    public void openInventory(PlayerWrapper wrapper) {
        SimpleInventoriesCore.openInventory(wrapper, this);
    }

    public SubInventory carriageReturn() {
        this.cursorPosition -= (this.cursorPosition - this.localOptions.getItemsOnRow()) % this.localOptions.getItemsOnRow();
        return this;
    }

    public SubInventory lineBreak() {
        this.cursorPosition += this.localOptions.getItemsOnRow() - this.cursorPosition % this.localOptions.getItemsOnRow();
        return this;
    }

    public SubInventory pageBreak() {
        this.cursorPosition += this.localOptions.getItemsOnPage() - this.cursorPosition % this.localOptions.getItemsOnPage();
        return this;
    }

    public SubInventory skip(int skip) {
        this.cursorPosition += skip;
        return this;
    }

    @Deprecated
    public SubInventory absolute(int absolute) {
        this.cursorPosition = absolute;
        return this;
    }

    public SubInventory column(int column) {
        this.cursorPosition = this.cursorPosition - this.cursorPosition % this.localOptions.getItemsOnRow() + column;
        return this;
    }

    public SubInventory column(Column column) {
        return this.column(column.convert(this.localOptions.getItemsOnRow()));
    }

    public SubInventory row(int row) {
        this.cursorPosition = this.cursorPosition - this.cursorPosition % this.localOptions.getItemsOnPage() + (row - 1) * this.localOptions.getItemsOnRow() + this.cursorPosition % this.localOptions.getItemsOnRow();
        return this;
    }

    public SubInventory addItem(@NotNull Queueable queueable) {
        this.process(queueable);
        this.forceReload();
        return this;
    }

    public SubInventory dropContents() {
        this.contents.stream().filter(GenericItemInfo::hasId).forEach(genericItemInfo -> this.inventorySet.getIds().remove(genericItemInfo.getId()));
        this.contents.clear();
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsOn(int position) {
        return this.dropContentsOn(List.of(Integer.valueOf(position)));
    }

    public SubInventory dropContentsOn(List<Integer> positions) {
        this.contents.removeIf(genericItemInfo -> {
            if (positions.contains(genericItemInfo.getPosition())) {
                if (genericItemInfo.hasId()) {
                    this.inventorySet.getIds().remove(genericItemInfo.getId());
                }
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsAfter(int position) {
        this.contents.removeIf(genericItemInfo -> {
            if (genericItemInfo.getPosition() >= position) {
                if (genericItemInfo.hasId()) {
                    this.inventorySet.getIds().remove(genericItemInfo.getId());
                }
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsBefore(int position) {
        this.contents.removeIf(genericItemInfo -> {
            if (genericItemInfo.getPosition() < position) {
                if (genericItemInfo.hasId()) {
                    this.inventorySet.getIds().remove(genericItemInfo.getId());
                }
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsBetween(int start, int end) {
        this.contents.removeIf(genericItemInfo -> {
            if (genericItemInfo.getPosition() >= start && genericItemInfo.getPosition() <= end) {
                if (genericItemInfo.hasId()) {
                    this.inventorySet.getIds().remove(genericItemInfo.getId());
                }
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsByFilter(Predicate<GenericItemInfo> filter) {
        this.contents.removeIf(genericItemInfo -> {
            if (filter.test((GenericItemInfo)genericItemInfo)) {
                if (genericItemInfo.hasId()) {
                    this.inventorySet.getIds().remove(genericItemInfo.getId());
                }
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    public SubInventory dropContentsById(@NotNull String id) {
        if (id.startsWith("$") || id.startsWith("\u00a7")) {
            id = id.substring(1);
        }
        String finalId = id;
        this.contents.removeIf(genericItemInfo -> {
            if (genericItemInfo.hasId() && finalId.equals(genericItemInfo.getId())) {
                this.inventorySet.getIds().remove(genericItemInfo.getId());
                return true;
            }
            return false;
        });
        this.forceReload();
        return this;
    }

    @Override
    public SubInventory putIntoQueue(Queueable ... items) {
        this.waitingQueue.addAll(Arrays.asList(items));
        return this;
    }

    @Override
    public Queue<Queueable> getQueue() {
        return this.waitingQueue;
    }

    public void forceReload() {
        SimpleInventoriesCore.getAllInventoryRenderersForSubInventory(this).forEach(InventoryRenderer::render);
    }

    public SubInventory(boolean main, @Nullable IdentifiableEntry itemOwner, @NotNull @NonNull InventorySet inventorySet) {
        if (inventorySet == null) {
            throw new NullPointerException("inventorySet is marked non-null but is null");
        }
        this.main = main;
        this.itemOwner = itemOwner;
        this.inventorySet = inventorySet;
    }

    public boolean isMain() {
        return this.main;
    }

    @Nullable
    public IdentifiableEntry getItemOwner() {
        return this.itemOwner;
    }

    @NotNull
    @NonNull
    public InventorySet getInventorySet() {
        return this.inventorySet;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public GenericItemInfo getLastItem() {
        return this.lastItem;
    }

    public List<GenericItemInfo> getContents() {
        return this.contents;
    }

    public Queue<Queueable> getWaitingQueue() {
        return this.waitingQueue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubInventory)) {
            return false;
        }
        SubInventory other = (SubInventory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMain() != other.isMain()) {
            return false;
        }
        if (this.getCursorPosition() != other.getCursorPosition()) {
            return false;
        }
        IdentifiableEntry this$itemOwner = this.getItemOwner();
        IdentifiableEntry other$itemOwner = other.getItemOwner();
        if (this$itemOwner == null ? other$itemOwner != null : !this$itemOwner.equals(other$itemOwner)) {
            return false;
        }
        InventorySet this$inventorySet = this.getInventorySet();
        InventorySet other$inventorySet = other.getInventorySet();
        if (this$inventorySet == null ? other$inventorySet != null : !((Object)this$inventorySet).equals(other$inventorySet)) {
            return false;
        }
        LocalOptions this$localOptions = this.getLocalOptions();
        LocalOptions other$localOptions = other.getLocalOptions();
        if (this$localOptions == null ? other$localOptions != null : !((Object)this$localOptions).equals(other$localOptions)) {
            return false;
        }
        GenericItemInfo this$lastItem = this.getLastItem();
        GenericItemInfo other$lastItem = other.getLastItem();
        if (this$lastItem == null ? other$lastItem != null : !((Object)this$lastItem).equals(other$lastItem)) {
            return false;
        }
        List<GenericItemInfo> this$contents = this.getContents();
        List<GenericItemInfo> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        Queue<Queueable> this$waitingQueue = this.getWaitingQueue();
        Queue<Queueable> other$waitingQueue = other.getWaitingQueue();
        return !(this$waitingQueue == null ? other$waitingQueue != null : !this$waitingQueue.equals(other$waitingQueue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubInventory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMain() ? 79 : 97);
        result = result * 59 + this.getCursorPosition();
        IdentifiableEntry $itemOwner = this.getItemOwner();
        result = result * 59 + ($itemOwner == null ? 43 : $itemOwner.hashCode());
        InventorySet $inventorySet = this.getInventorySet();
        result = result * 59 + ($inventorySet == null ? 43 : ((Object)$inventorySet).hashCode());
        LocalOptions $localOptions = this.getLocalOptions();
        result = result * 59 + ($localOptions == null ? 43 : ((Object)$localOptions).hashCode());
        GenericItemInfo $lastItem = this.getLastItem();
        result = result * 59 + ($lastItem == null ? 43 : ((Object)$lastItem).hashCode());
        List<GenericItemInfo> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        Queue<Queueable> $waitingQueue = this.getWaitingQueue();
        result = result * 59 + ($waitingQueue == null ? 43 : $waitingQueue.hashCode());
        return result;
    }

    public String toString() {
        return "SubInventory(main=" + this.isMain() + ", localOptions=" + this.getLocalOptions() + ", cursorPosition=" + this.getCursorPosition() + ", lastItem=" + this.getLastItem() + ", contents=" + this.getContents() + ")";
    }

    @Deprecated
    public void setInventorySet(@NotNull @NonNull InventorySet inventorySet) {
        if (inventorySet == null) {
            throw new NullPointerException("inventorySet is marked non-null but is null");
        }
        this.inventorySet = inventorySet;
    }
}

