/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.loaders;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.simpleinventories.dependencies.DependencyHelper;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.loaders.ConfigurateLoader;
import io.github.pronze.lib.simpleinventories.loaders.ILoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CsvLoader
implements ILoader {
    @Override
    public void loadPathInto(SubInventory subInventory, Path path, String configPath) throws Exception {
        DependencyHelper.UNIVOCITY.load();
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        CsvParserSettings settings = new CsvParserSettings();
        settings.detectFormatAutomatically(new char[0]);
        CsvParser parser = new CsvParser(settings);
        List rows = parser.parseAll(path.toFile());
        String[] header = null;
        for (String[] row : rows) {
            if (header == null) {
                header = row;
                continue;
            }
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (int i = 0; i < row.length && i < header.length; ++i) {
                map2.put(header[i], row[i]);
            }
            list.add(map2);
        }
        BasicConfigurationNode node = BasicConfigurationNode.root();
        list.forEach(map -> {
            BasicConfigurationNode child = (BasicConfigurationNode)node.appendListNode();
            map.forEach((s, o) -> {
                try {
                    ((BasicConfigurationNode)child.node(s.split("\\."))).set(o);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            });
        });
        ConfigurateLoader.loadConfigurationNodeInto(subInventory, node);
    }
}

