/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyInviteEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyInviteCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p invite <invitee>")
    private void commandInvite(@NotNull Player playerArg, @Argument(value="invitee") @NotNull Player invitee) {
        SBAPlayerWrapper player;
        SBAPlayerWrapper invitedPlayer = SBA.getInstance().getPlayerWrapper(invitee);
        if (invitedPlayer.equals(player = SBA.getInstance().getPlayerWrapper(playerArg))) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CANNOT_INVITE_YOURSELF).send(player);
            return;
        }
        if (invitedPlayer.getSettings().isToggled(PlayerSetting.INVITED_TO_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_INVITED).send(player);
            return;
        }
        if (invitedPlayer.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CANNOT_INVITE).send(player);
            return;
        }
        PartyManager.getInstance().getOrCreate(player).ifPresent(party -> {
            if (party.getInvitedPlayers().size() > 5) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_MAX_INVITE_SIZE_REACHED).send(player);
                return;
            }
            if (party.getMembers().size() + party.getInvitedPlayers().size() > SBAConfig.getInstance().getInt("party.size", 4)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_MAX_INVITE_SIZE_REACHED).send(player);
                return;
            }
            SBAPlayerPartyInviteEvent inviteEvent = new SBAPlayerPartyInviteEvent(player, invitedPlayer);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)inviteEvent);
            if (inviteEvent.isCancelled()) {
                return;
            }
            party.invitePlayer(invitedPlayer, player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_SENT).replace("%player%", invitedPlayer.getName()).send(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_RECEIVED).replace("%player%", player.getName()).send(invitedPlayer);
        });
    }
}

