/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.player.ExtendablePlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyKickEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyKickCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnable() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("kick", (ctx, s) -> {
            SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper((Player)ctx.getSender());
            Optional<IParty> optionalParty = SBA.getInstance().getPartyManager().getPartyOf(player);
            if (optionalParty.isEmpty() || !player.getSettings().isToggled(PlayerSetting.IN_PARTY) || !player.equals(optionalParty.get().getPartyLeader())) {
                return List.of();
            }
            return optionalParty.get().getMembers().stream().map(ExtendablePlayerWrapper::getName).filter(name -> !player.getName().equalsIgnoreCase((String)name)).collect(Collectors.toList());
        });
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p kick <player>")
    private void commandKick(@NotNull Player playerArg, @Argument(value="player", suggestions="kick") @NotNull Player toKick) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        SBAPlayerWrapper args = SBA.getInstance().getPlayerWrapper(toKick);
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!party.getPartyLeader().equals(player)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (!party.getMembers().contains(args)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PLAYER_NOT_FOUND).send(player);
                return;
            }
            SBAPlayerPartyKickEvent kickEvent = new SBAPlayerPartyKickEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)kickEvent);
            if (kickEvent.isCancelled()) {
                return;
            }
            party.removePlayer(args);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_KICKED).replace("%player%", args.getName()).send((CommandSenderWrapper[])party.getMembers().toArray(SBAPlayerWrapper[]::new));
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_KICKED_RECEIVED).send(args);
            if (party.getMembers().size() == 1) {
                PartyManager.getInstance().disband(party.getUUID());
            }
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

