/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.player.ExtendablePlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyPromoteEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyPromoteCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnable() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("promote", (ctx, s) -> {
            Optional<IParty> optionalParty = PartyManager.getInstance().getPartyOf(SBA.getInstance().getPlayerWrapper((Player)ctx.getSender()));
            if (optionalParty.isEmpty()) {
                return List.of();
            }
            return optionalParty.get().getMembers().stream().map(ExtendablePlayerWrapper::getName).collect(Collectors.toList());
        });
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p promote <player>")
    private void commandPromote(@NotNull Player playerArg, @Argument(value="player", suggestions="promote") @NotNull Player toPromote) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        SBAPlayerWrapper args = SBA.getInstance().getPlayerWrapper(toPromote);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        SBA.getInstance().getPartyManager().getPartyOf(player).ifPresentOrElse(party -> {
            if (!party.getPartyLeader().equals(player)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            SBAPlayerPartyPromoteEvent partyPromoteEvent = new SBAPlayerPartyPromoteEvent(player, args);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)partyPromoteEvent);
            if (partyPromoteEvent.isCancelled()) {
                return;
            }
            party.setPartyLeader(args);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PROMOTED_LEADER).replace("%player%", args.getName()).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

