/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyMutedEvent;
import io.github.pronze.sba.events.SBAPlayerPartyUnmutedEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartySettingsCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p mute")
    private void commandMute(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getChat() == PartySetting.Chat.UNMUTE) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_MUTED).replace("%isMuted%", "unmuted").send(player);
            }
            SBAPlayerPartyMutedEvent muteEvent = new SBAPlayerPartyMutedEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)muteEvent);
            if (muteEvent.isCancelled()) {
                return;
            }
            party.getSettings().setChat(PartySetting.Chat.MUTED);
            party.getMembers().forEach(member -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CHAT_ENABLED_OR_DISABLED).replace("%mode%", "muted").send((CommandSenderWrapper)member));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }

    @CommandMethod(value="party|p unmute")
    private void commandUnmute(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getSettings().getChat() == PartySetting.Chat.MUTED) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_MUTED).replace("%isMuted%", "unmuted").send(player);
                return;
            }
            SBAPlayerPartyUnmutedEvent unmuteEvent = new SBAPlayerPartyUnmutedEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)unmuteEvent);
            if (unmuteEvent.isCancelled()) {
                return;
            }
            party.getSettings().setChat(PartySetting.Chat.MUTED);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CHAT_ENABLED_OR_DISABLED).replace("%mode%", "unmuted").send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

