/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.config;

import io.github.pronze.lib.configurate.ConfigurateException;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.loader.AbstractConfigurationLoader;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ConfigGenerator {
    private final AbstractConfigurationLoader<?> loader;
    private final ConfigurationNode mainNode;
    private boolean modified = false;

    public ConfigSection start() {
        return new ConfigSection(null, this.mainNode);
    }

    public void saveIfModified() throws ConfigurateException {
        if (this.modified) {
            this.loader.save(this.mainNode);
        }
    }

    public ConfigGenerator(AbstractConfigurationLoader<?> loader, ConfigurationNode mainNode) {
        this.loader = loader;
        this.mainNode = mainNode;
    }

    public class ConfigSection {
        private final ConfigSection previous;
        private final ConfigurationNode section;

        public ConfigSection section(Object ... keys) {
            return new ConfigSection(this, this.section.node(keys));
        }

        public ConfigValue key(Object ... keys) {
            return new ConfigValue(this.section.node(keys));
        }

        public ConfigSection drop(Object ... keys) throws SerializationException {
            ConfigurationNode drop = this.section.node(keys);
            if (!drop.virtual()) {
                this.section.node(keys).set(null);
                ConfigGenerator.this.modified = true;
            }
            return this;
        }

        public ConfigSection back() {
            return Objects.requireNonNullElse(this.previous, this);
        }

        private ConfigSection(ConfigSection previous, ConfigurationNode section) {
            this.previous = previous;
            this.section = section;
        }

        public class ConfigValue {
            private final ConfigurationNode selected;
            private ConfigurationNode migration;
            private Consumer<ConfigurationNode> remapConsumer;
            private boolean clearMigration = true;

            public ConfigValue migrateOld(Object ... keys) throws SerializationException {
                return this.migrate(ConfigSection.this.section, keys);
            }

            public ConfigValue migrateOldAbsoluteKey(Object ... keys) throws SerializationException {
                return this.migrate(ConfigGenerator.this.mainNode, keys);
            }

            private ConfigValue migrate(ConfigurationNode node, Object[] keys) throws SerializationException {
                if (this.migration != null) {
                    this.migrate();
                }
                this.migration = node.node(keys);
                return this;
            }

            public ConfigValue remap(Consumer<ConfigurationNode> remapConsumer) {
                this.remapConsumer = remapConsumer;
                return this;
            }

            public ConfigValue preventOldKeyRemove() {
                this.clearMigration = false;
                return this;
            }

            public ConfigSection defValue(Object defaultValue) throws SerializationException {
                return this.defValue(() -> defaultValue);
            }

            public ConfigSection defValue(Supplier<Object> defaultValue) throws SerializationException {
                if (this.migration != null) {
                    this.migrate();
                }
                if (this.selected.virtual()) {
                    this.selected.set(defaultValue.get());
                    ConfigGenerator.this.modified = true;
                }
                return ConfigSection.this;
            }

            public ConfigSection moveIf(Predicate<ConfigurationNode> condition, Object ... newKeys) throws SerializationException {
                if (!this.selected.virtual() && condition.test(this.selected)) {
                    ConfigSection.this.section.node(newKeys).from(this.selected);
                    this.selected.set(null);
                    ConfigGenerator.this.modified = true;
                }
                return ConfigSection.this;
            }

            public ConfigSection moveIfAbsolute(Predicate<ConfigurationNode> condition, Object ... newKeys) throws SerializationException {
                if (!this.selected.virtual() && condition.test(this.selected)) {
                    ConfigurationNode copy = this.selected.copy();
                    this.selected.set(null);
                    ConfigGenerator.this.mainNode.node(newKeys).from(copy);
                    ConfigGenerator.this.modified = true;
                }
                return ConfigSection.this;
            }

            private void migrate() throws SerializationException {
                if (!this.migration.virtual()) {
                    if (this.remapConsumer != null) {
                        this.remapConsumer.accept(this.migration);
                    }
                    if (this.selected.virtual()) {
                        this.selected.from(this.migration);
                        ConfigGenerator.this.modified = true;
                    }
                    if (this.clearMigration) {
                        this.migration.set(null);
                        ConfigGenerator.this.modified = true;
                    }
                    this.migration = null;
                    this.remapConsumer = null;
                }
            }

            private ConfigValue(ConfigurationNode selected) {
                this.selected = selected;
            }
        }
    }
}

