/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.data.GameTeamData;
import io.github.pronze.sba.game.IGameStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;

public class GameStorage
implements IGameStorage {
    private final Map<RunningTeam, GameTeamData> teamDataMap = new HashMap<RunningTeam, GameTeamData>();
    private RunningTeam team;

    public GameStorage(Game game) {
        game.getRunningTeams().forEach(team -> this.teamDataMap.put((RunningTeam)team, GameTeamData.of((Team)team)));
    }

    @Override
    public Optional<Location> getTargetBlockLocation(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            this.teamDataMap.put(team, GameTeamData.of((Team)team));
        }
        return Optional.ofNullable(this.teamDataMap.get(team).getTargetBlockLoc());
    }

    @Override
    public Optional<Integer> getSharpnessLevel(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            this.teamDataMap.put(team, GameTeamData.of((Team)team));
        }
        return Optional.of(this.teamDataMap.get(team).getSharpness());
    }

    @Override
    public Optional<Integer> getProtectionLevel(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            this.teamDataMap.put(team, GameTeamData.of((Team)team));
        }
        return Optional.of(this.teamDataMap.get(team).getProtection());
    }

    @Override
    public Optional<Integer> getEfficiencyLevel(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            this.teamDataMap.put(team, GameTeamData.of((Team)team));
        }
        return Optional.of(this.teamDataMap.get(team).getEfficiency());
    }

    @Override
    public void setSharpnessLevel(@NotNull RunningTeam team, @NotNull Integer level) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setSharpness(level);
    }

    @Override
    public void setProtectionLevel(@NotNull RunningTeam team, @NotNull Integer level) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setProtection(level);
    }

    @Override
    public void setEfficiencyLevel(@NotNull RunningTeam team, @NotNull Integer level) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setEfficiency(level);
    }

    @Override
    public void setPurchasedBlindTrap(@NotNull RunningTeam team, boolean isBlindTrapEnabled) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setPurchasedBlindTrap(isBlindTrapEnabled);
    }

    @Override
    public void setPurchasedMinerTrap(@NotNull RunningTeam team, boolean isMinerTrapEnabled) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setPurchasedBlindTrap(isMinerTrapEnabled);
    }

    @Override
    public void setPurchasedPool(@NotNull RunningTeam team, boolean isPoolEnabled) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setPurchasedPool(isPoolEnabled);
    }

    @Override
    public void setPurchasedDragons(@NotNull RunningTeam team, boolean isDragonEnabled) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        this.teamDataMap.get(team).setPurchasedDragonUpgrade(isDragonEnabled);
    }

    @Override
    public boolean areBlindTrapEnabled(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        return this.teamDataMap.get(team).isPurchasedBlindTrap();
    }

    @Override
    public boolean areMinerTrapEnabled(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        return this.teamDataMap.get(team).isPurchasedMinerTrap();
    }

    @Override
    public boolean arePoolEnabled(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        return this.teamDataMap.get(team).isPurchasedPool();
    }

    @Override
    public boolean areDragonsEnabled(@NotNull RunningTeam team) {
        if (!this.teamDataMap.containsKey(team)) {
            throw new UnsupportedOperationException("Team: " + team.getName() + " has not been registered yet!");
        }
        return this.teamDataMap.get(team).isPurchasedDragonUpgrade();
    }

    @Override
    public boolean areDragonsEnabled() {
        return this.teamDataMap.values().stream().anyMatch(GameTeamData::isPurchasedDragonUpgrade);
    }

    @Override
    public boolean areBlindTrapEnabled() {
        return this.teamDataMap.values().stream().anyMatch(GameTeamData::isPurchasedBlindTrap);
    }

    @Override
    public boolean areMinerTrapEnabled() {
        return this.teamDataMap.values().stream().anyMatch(GameTeamData::isPurchasedMinerTrap);
    }

    @Override
    public boolean arePoolEnabled() {
        return this.teamDataMap.values().stream().anyMatch(GameTeamData::isPurchasedPool);
    }
}

