/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.sba.AddonAPI;
import java.util.Arrays;

public enum GameTierEvent {
    DIAMOND_GEN_UPGRADE_TIER_II("Diamond-II"),
    EMERALD_GEN_UPGRADE_TIER_II("Emerald-II"),
    DIAMOND_GEN_UPGRADE_TIER_III("Diamond-III"),
    EMERALD_GEN_UPGRADE_TIER_III("Emerald-III"),
    DIAMOND_GEN_UPGRADE_TIER_IV("Diamond-IV"),
    EMERALD_GEN_UPGRADE_TIER_V("Emerald-IV"),
    GAME_END("GameEnd");

    private final String key;

    public int getTime() {
        return AddonAPI.getInstance().getConfigurator().getInt("upgrades.time." + this.key, Integer.MAX_VALUE);
    }

    public static GameTierEvent ofOrdinal(int ordinal) {
        return Arrays.stream(GameTierEvent.values()).filter(val -> val.ordinal() == ordinal).findAny().orElse(GAME_END);
    }

    public GameTierEvent getNextEvent() {
        return GameTierEvent.ofOrdinal(this.ordinal() + 1);
    }

    private GameTierEvent(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }
}

