/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.holder.ScoreboardHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEquipmentPacket;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotMapping;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.InvisiblePlayer;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.visuals.GameScoreboardManager;
import java.util.Map;
import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.TeamColor;

public class InvisiblePlayerImpl
implements InvisiblePlayer {
    private final Player hiddenPlayer;
    private final Arena arena;
    private boolean justEquipped = false;
    private boolean isHidden;
    protected BukkitTask armorHider;

    @Override
    public void vanish() {
        Logger.trace("InvisiblePlayerImpl.vanish{}", this.hiddenPlayer);
        RunningTeam team = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        if (team == null) {
            return;
        }
        String invisTeamName = "i-" + team.getName();
        this.arena.getGame().getConnectedPlayers().forEach(connectedPlayers -> {
            GameScoreboardManager gameScoreboardManager = (GameScoreboardManager)this.arena.getScoreboardManager();
            Optional<Scoreboard> maybeHolder = gameScoreboardManager.getScoreboard(connectedPlayers.getUniqueId());
            if (maybeHolder.isEmpty()) {
                return;
            }
            ScoreboardHolder holder = maybeHolder.get().getHolder();
            if (!holder.hasTeamEntry(invisTeamName)) {
                holder.addTeam(invisTeamName, TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
                holder.getTeamEntry(invisTeamName).ifPresent(invisibleScoreboardTeam -> invisibleScoreboardTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER));
            }
            Team invisibleScoreboardTeam2 = holder.getTeamOrRegister(invisTeamName);
            holder.getTeamEntry(team.getName()).ifPresent(entry -> {
                if (entry.hasEntry(this.hiddenPlayer.getName())) {
                    entry.removeEntry(this.hiddenPlayer.getName());
                }
            });
            if (!invisibleScoreboardTeam2.hasEntry(this.hiddenPlayer.getName())) {
                invisibleScoreboardTeam2.addEntry(this.hiddenPlayer.getName());
            }
        });
        Logger.trace("Hiding player: {} for invisibility", this.hiddenPlayer.getName());
        if (this.isHidden) {
            return;
        }
        this.isHidden = true;
        this.hideArmor();
        this.armorHider = new BukkitRunnable(){

            public void run() {
                if (!InvisiblePlayerImpl.this.isElligble() || !InvisiblePlayerImpl.this.isHidden) {
                    InvisiblePlayerImpl.this.showPlayer();
                    this.cancel();
                    InvisiblePlayerImpl.this.arena.removeHiddenPlayer(InvisiblePlayerImpl.this.hiddenPlayer);
                }
            }
        }.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 20L);
    }

    private boolean isElligble() {
        return this.arena.getGame().getStatus() == GameStatus.RUNNING && (this.hiddenPlayer.getGameMode() == GameMode.SURVIVAL || this.hiddenPlayer.getGameMode() == GameMode.CREATIVE) && this.hiddenPlayer.isOnline() && this.hiddenPlayer.hasPotionEffect(PotionEffectType.INVISIBILITY) && this.arena.getGame().getConnectedPlayers().contains(this.hiddenPlayer);
    }

    private void showArmor() {
        ItemStack boots = this.hiddenPlayer.getInventory().getBoots();
        ItemStack helmet = this.hiddenPlayer.getInventory().getHelmet();
        ItemStack chestplate = this.hiddenPlayer.getInventory().getChestplate();
        ItemStack leggings = this.hiddenPlayer.getInventory().getLeggings();
        ItemStack currentHand = this.hiddenPlayer.getInventory().getItemInMainHand();
        this.arena.getGame().getConnectedPlayers().forEach(pl -> this.getEquipPacket(this.convert(helmet), this.convert(chestplate), this.convert(leggings), this.convert(boots), this.convert(currentHand)).sendPacket(PlayerMapper.wrapPlayer(pl)));
    }

    public Item convert(ItemStack itemStack) {
        return ItemFactory.build(itemStack).orElse(ItemFactory.getAir());
    }

    private void hideArmor() {
        RunningTeam hiddenPlayerTeam = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        Item airStack = ItemFactory.getAir();
        this.arena.getGame().getConnectedPlayers().stream().filter(pl -> !hiddenPlayerTeam.getConnectedPlayers().contains(pl)).forEach(pl -> {
            Logger.trace("Sending hide packets to player: {} for hider: {}", pl.getName(), this.hiddenPlayer.getName());
            this.getEquipPacket(airStack, airStack, airStack, airStack, this.convert(this.hiddenPlayer.getInventory().getItemInMainHand())).sendPacket(PlayerMapper.wrapPlayer(pl));
        });
    }

    @Override
    public void refresh() {
        Item airStack = ItemFactory.getAir();
        RunningTeam hiddenPlayerTeam = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        Tasker.build(() -> this.arena.getGame().getConnectedPlayers().stream().filter(pl -> !hiddenPlayerTeam.getConnectedPlayers().contains(pl)).forEach(pl -> {
            Logger.trace("Sending hide packets to player: {} for hider: {}", pl.getName(), this.hiddenPlayer.getName());
            this.getEquipPacket(airStack, airStack, airStack, airStack, this.convert(this.hiddenPlayer.getInventory().getItemInMainHand())).sendPacket(PlayerMapper.wrapPlayer(pl));
        })).afterOneTick().start();
    }

    private SClientboundSetEquipmentPacket getEquipPacket(Item helmet, Item chestPlate, Item leggings, Item boots, Item hand) {
        SClientboundSetEquipmentPacket packet = new SClientboundSetEquipmentPacket();
        packet.entityId(this.hiddenPlayer.getEntityId());
        Map<EquipmentSlotHolder, Item> slots = packet.slots();
        if (hand != null) {
            slots.put(EquipmentSlotMapping.resolve("HAND").orElseThrow(), hand);
        }
        if (helmet != null) {
            slots.put(EquipmentSlotMapping.resolve("HEAD").orElseThrow(), helmet);
        }
        if (chestPlate != null) {
            slots.put(EquipmentSlotMapping.resolve("CHEST").orElseThrow(), chestPlate);
        }
        if (leggings != null) {
            slots.put(EquipmentSlotMapping.resolve("LEGS").orElseThrow(), leggings);
        }
        if (boots != null) {
            slots.put(EquipmentSlotMapping.resolve("FEET").orElseThrow(), boots);
        }
        return packet;
    }

    @Override
    public void showPlayer() {
        RunningTeam team = this.arena.getGame().getTeamOfPlayer(this.hiddenPlayer);
        if (team == null) {
            return;
        }
        String invisTeamName = "i-" + team.getName();
        this.arena.getGame().getConnectedPlayers().forEach(connectedPlayers -> {
            Team invisibleScoreboardTeam2;
            GameScoreboardManager gameScoreboardManager = (GameScoreboardManager)this.arena.getScoreboardManager();
            Optional<Scoreboard> maybeHolder = gameScoreboardManager.getScoreboard(connectedPlayers.getUniqueId());
            if (maybeHolder.isEmpty()) {
                return;
            }
            ScoreboardHolder holder = maybeHolder.get().getHolder();
            if (!holder.hasTeamEntry(invisTeamName)) {
                holder.addTeam(invisTeamName, TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
                holder.getTeamEntry(invisTeamName).ifPresent(invisibleScoreboardTeam -> invisibleScoreboardTeam.setNameTagVisibility(NameTagVisibility.NEVER));
            }
            if ((invisibleScoreboardTeam2 = holder.getTeamOrRegister(invisTeamName)).hasEntry(this.hiddenPlayer.getName())) {
                invisibleScoreboardTeam2.removeEntry(this.hiddenPlayer.getName());
            }
            holder.getTeamEntry(team.getName()).ifPresent(entry -> {
                if (!entry.hasEntry(this.hiddenPlayer.getName())) {
                    entry.addEntry(this.hiddenPlayer.getName());
                }
            });
        });
        SBAUtil.cancelTask(this.armorHider);
        this.showArmor();
        this.isHidden = false;
        Logger.trace("Un hiding player: {}", this.hiddenPlayer.getName());
        this.hiddenPlayer.removePotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public Player getHiddenPlayer() {
        return null;
    }

    @Override
    public void setHidden(boolean hidden) {
    }

    @Override
    public boolean isJustEquipped() {
        return false;
    }

    @Override
    public void setJustEquipped(boolean justEquipped) {
    }

    public InvisiblePlayerImpl(Player hiddenPlayer, Arena arena) {
        this.hiddenPlayer = hiddenPlayer;
        this.arena = arena;
    }

    public Arena getArena() {
        return this.arena;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public BukkitTask getArmorHider() {
        return this.armorHider;
    }

    public void setArmorHider(BukkitTask armorHider) {
        this.armorHider = armorHider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvisiblePlayerImpl)) {
            return false;
        }
        InvisiblePlayerImpl other = (InvisiblePlayerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isJustEquipped() != other.isJustEquipped()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        Player this$hiddenPlayer = this.getHiddenPlayer();
        Player other$hiddenPlayer = other.getHiddenPlayer();
        if (this$hiddenPlayer == null ? other$hiddenPlayer != null : !this$hiddenPlayer.equals(other$hiddenPlayer)) {
            return false;
        }
        Arena this$arena = this.getArena();
        Arena other$arena = other.getArena();
        if (this$arena == null ? other$arena != null : !this$arena.equals(other$arena)) {
            return false;
        }
        BukkitTask this$armorHider = this.getArmorHider();
        BukkitTask other$armorHider = other.getArmorHider();
        return !(this$armorHider == null ? other$armorHider != null : !this$armorHider.equals(other$armorHider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvisiblePlayerImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isJustEquipped() ? 79 : 97);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        Player $hiddenPlayer = this.getHiddenPlayer();
        result = result * 59 + ($hiddenPlayer == null ? 43 : $hiddenPlayer.hashCode());
        Arena $arena = this.getArena();
        result = result * 59 + ($arena == null ? 43 : $arena.hashCode());
        BukkitTask $armorHider = this.getArmorHider();
        result = result * 59 + ($armorHider == null ? 43 : $armorHider.hashCode());
        return result;
    }

    public String toString() {
        return "InvisiblePlayerImpl(hiddenPlayer=" + this.getHiddenPlayer() + ", arena=" + this.getArena() + ", justEquipped=" + this.isJustEquipped() + ", isHidden=" + this.isHidden() + ", armorHider=" + this.getArmorHider() + ")";
    }
}

