/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.hologram.Hologram;
import io.github.pronze.lib.screaminglib.hologram.HologramManager;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.game.ItemSpawner;

public class RotatingGenerator
implements IRotatingGenerator {
    private Location location;
    private List<String> lines;
    private int time;
    private int tierLevel = 1;
    private final ItemSpawner itemSpawner;
    private final ItemStack stack;
    private BukkitTask hologramTask;
    private Hologram hologram;
    private List<Item> spawnedItems;

    public RotatingGenerator(ItemSpawner itemSpawner, ItemStack stack, Location location) {
        this.itemSpawner = itemSpawner;
        this.stack = stack;
        this.location = location;
        this.time = itemSpawner.getItemSpawnerType().getInterval() + 1;
        this.lines = LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FORMAT).toStringList();
        this.spawnedItems = (List)Reflect.getField((Object)itemSpawner, "spawnedItems");
    }

    @Override
    public void spawn(@NotNull List<Player> viewers) {
        Logger.trace("RotatingGenerator::spawn ({},{})", this, viewers);
        double holoHeight = SBAConfig.getInstance().node("floating-generator", "height").getDouble(2.0);
        this.hologram = HologramManager.hologram(LocationMapper.wrapLocation(this.location.clone().add(0.0, holoHeight, 0.0)));
        this.hologram.item(ItemFactory.build(this.stack).orElseThrow()).itemPosition(Hologram.ItemPosition.BELOW).rotationMode(Hologram.RotationMode.Y).rotationTime(Pair.of(1, TaskerTime.TICKS));
        this.hologram.show();
        viewers.forEach(player -> this.hologram.addViewer(PlayerMapper.wrapPlayer(player)));
        this.scheduleTasks();
    }

    @Override
    public void addViewer(@NotNull Player player) {
        this.hologram.addViewer(PlayerMapper.wrapPlayer(player));
    }

    @Override
    public void removeViewer(@NotNull Player player) {
        this.hologram.removeViewer(PlayerMapper.wrapPlayer(player));
    }

    protected void scheduleTasks() {
        SBAUtil.cancelTask(this.hologramTask);
        this.hologramTask = new BukkitRunnable(){

            public void run() {
                boolean full;
                RotatingGenerator.this.hologram.show();
                boolean bl = full = RotatingGenerator.this.itemSpawner.getMaxSpawnedResources() <= RotatingGenerator.this.spawnedItems.size();
                if (!full) {
                    --RotatingGenerator.this.time;
                }
                List<String> format = !full ? LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FORMAT).toStringList() : LanguageService.getInstance().get(MessageKeys.ROTATING_GENERATOR_FULL_TEXT_FORMAT).toStringList();
                ArrayList<String> newLines = new ArrayList<String>();
                String matName = RotatingGenerator.this.itemSpawner.getItemSpawnerType().getMaterial() == Material.EMERALD ? "\u00a7a" + LanguageService.getInstance().get(MessageKeys.EMERALD).toString() : "\u00a7b" + LanguageService.getInstance().get(MessageKeys.DIAMOND).toString();
                for (String line : format) {
                    newLines.add(line.replace("%tier%", ShopUtil.romanNumerals.get(RotatingGenerator.this.tierLevel)).replace("%material%", matName + "\u00a76").replace("%seconds%", String.valueOf(RotatingGenerator.this.time)));
                }
                RotatingGenerator.this.update(newLines);
                if (RotatingGenerator.this.time <= 0 || full) {
                    RotatingGenerator.this.time = RotatingGenerator.this.itemSpawner.getItemSpawnerType().getInterval();
                }
            }
        }.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 20L);
    }

    @Override
    public void update(@NotNull List<String> newLines) {
        if (newLines.equals(this.lines)) {
            return;
        }
        for (int i = 0; i < newLines.size(); ++i) {
            this.hologram.replaceLine((Integer)i, Component.text(newLines.get(i)));
        }
        this.lines = new ArrayList<String>(newLines);
    }

    @Override
    public void destroy() {
        Logger.trace("RotatingGenerator::destroy ({})", this);
        SBAUtil.cancelTask(this.hologramTask);
        if (this.hologram != null) {
            this.hologram.destroy();
            this.hologram = null;
        }
    }

    @Override
    public void setLocation(@NotNull Location location) {
        this.location = location;
    }

    public int getTierLevel() {
        return this.tierLevel;
    }

    public void setTierLevel(int tierLevel) {
        this.tierLevel = tierLevel;
    }

    public ItemSpawner getItemSpawner() {
        return this.itemSpawner;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

