/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBASpawnerTierUpgradeEvent;
import io.github.pronze.sba.game.GameTierEvent;
import io.github.pronze.sba.game.GeneratorUpgradeType;
import io.github.pronze.sba.game.IRotatingGenerator;
import io.github.pronze.sba.game.RotatingGenerator;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.lib.lang.LanguageService;
import java.text.SimpleDateFormat;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;

public class GeneratorTask
extends BaseGameTask {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("mm:ss");
    private final String diamond;
    private final String emerald;
    private final double multiplier;
    private final boolean timerUpgrades;
    private final boolean showUpgradeMessage;
    private GameTierEvent nextEvent = GameTierEvent.DIAMOND_GEN_UPGRADE_TIER_II;
    private int elapsedTime;

    public GeneratorTask() {
        this.diamond = LanguageService.getInstance().get(MessageKeys.DIAMOND).toString();
        this.emerald = LanguageService.getInstance().get(MessageKeys.EMERALD).toString();
        this.timerUpgrades = SBAConfig.getInstance().getBoolean("upgrades.timer-upgrades-enabled", true);
        this.showUpgradeMessage = SBAConfig.getInstance().getBoolean("upgrades.show-upgrade-message", true);
        this.multiplier = SBAConfig.getInstance().getDouble("upgrades.multiplier", 0.25);
    }

    @Override
    public void run() {
        if (this.nextEvent != GameTierEvent.GAME_END && this.elapsedTime == this.nextEvent.getTime()) {
            if (this.timerUpgrades) {
                String tierName = this.nextEvent.getKey();
                GeneratorUpgradeType upgradeType = GeneratorUpgradeType.fromString(tierName.substring(0, tierName.indexOf("-")));
                String matName = null;
                Material type = null;
                switch (upgradeType) {
                    case DIAMOND: {
                        matName = "\u00a7b" + this.diamond;
                        type = Material.DIAMOND_BLOCK;
                        break;
                    }
                    case EMERALD: {
                        matName = "\u00a7a" + this.emerald;
                        type = Material.EMERALD_BLOCK;
                    }
                }
                boolean emptyQuery = this.game.getItemSpawners().stream().filter(itemSpawner -> itemSpawner.getItemSpawnerType().getMaterial() == upgradeType.getMaterial()).findAny().isEmpty();
                if (emptyQuery) {
                    type = null;
                }
                this.game.getItemSpawners().forEach(itemSpawner -> {
                    if (itemSpawner.getItemSpawnerType().getMaterial() == upgradeType.getMaterial()) {
                        itemSpawner.addToCurrentLevel(this.multiplier);
                    }
                });
                Material finalType = type;
                this.arena.getRotatingGenerators().stream().map(generator -> (RotatingGenerator)generator).filter(generator -> generator.getStack().getType() == finalType).forEach(generator -> {
                    SBASpawnerTierUpgradeEvent event = new SBASpawnerTierUpgradeEvent(this.game, (IRotatingGenerator)generator);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    generator.setTierLevel(generator.getTierLevel() + 1);
                });
                if (this.showUpgradeMessage && finalType != null) {
                    LanguageService.getInstance().get(MessageKeys.GENERATOR_UPGRADE_MESSAGE).replace("%MatName%", matName).replace("%tier%", tierName).send((CommandSenderWrapper[])this.game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).toArray(PlayerWrapper[]::new));
                }
            }
            this.nextEvent = this.nextEvent.getNextEvent();
        }
        ++this.elapsedTime;
    }

    public String getTimeLeftForNextEvent() {
        return dateFormat.format((this.nextEvent.getTime() - this.elapsedTime) * 1000);
    }

    public String getNextTierName() {
        if (this.nextEvent == GameTierEvent.GAME_END) {
            return LanguageService.getInstance().get(MessageKeys.GAME_END_MESSAGE).toString();
        }
        return this.nextEvent.getKey();
    }
}

