/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBATeamTrapTriggeredEvent;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.utils.Sounds;

public class MinerTrapTask
extends BaseGameTask {
    private final double radius = Math.pow(SBAConfig.getInstance().node("upgrades", "trap-detection-range").getInt(7), 2.0);

    @Override
    public void run() {
        if (!this.arena.getStorage().areMinerTrapEnabled()) {
            return;
        }
        this.arena.getGame().getRunningTeams().stream().filter(this.arena.getStorage()::areMinerTrapEnabled).forEach(team -> this.arena.getGame().getConnectedPlayers().stream().filter(player -> !Main.getPlayerGameProfile((Player)player).isSpectator).filter(player -> !team.getConnectedPlayers().contains(player)).forEach(player -> {
            if (this.arena.getStorage().getTargetBlockLocation((RunningTeam)team).orElseThrow().distanceSquared(player.getLocation()) <= this.radius) {
                SBATeamTrapTriggeredEvent triggeredEvent = new SBATeamTrapTriggeredEvent((Player)player, (RunningTeam)team, this.arena);
                SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)triggeredEvent);
                if (triggeredEvent.isCancelled()) {
                    return;
                }
                this.arena.getStorage().setPurchasedMinerTrap((RunningTeam)team, false);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 200, 2));
                if (this.arena.isPlayerHidden((Player)player)) {
                    this.arena.removeHiddenPlayer((Player)player);
                }
                LanguageService.getInstance().get(MessageKeys.TEAM_MINER_TRAP_TRIGGERED_MESSAGE).replace("%team%", this.arena.getGame().getTeamOfPlayer(player).getName()).send(PlayerMapper.wrapPlayer(player).as(SBAPlayerWrapper.class));
                String title = LanguageService.getInstance().get(MessageKeys.TEAM_MINER_TRAP_TRIGGERED_TITLE).toString();
                String subTitle = LanguageService.getInstance().get(MessageKeys.TEAM_MINER_TRAP_TRIGGERED_SUBTITLE).toString();
                team.getConnectedPlayers().forEach(pl -> {
                    String sound = SBAConfig.getInstance().getString("sounds.on_trap_triggered", "ENTITY_ENDER_DRAGON_GROWL");
                    if (sound == null) {
                        sound = "ENTITY_ENDER_DRAGON_GROWL";
                    }
                    Sounds.playSound((Player)pl, (Location)pl.getLocation(), (String)sound, (Sounds)Sounds.ENTITY_ENDERMAN_TELEPORT, (float)1.0f, (float)1.0f);
                    SBAUtil.sendTitle(PlayerMapper.wrapPlayer(pl), title, subTitle, 20, 60, 0);
                });
            }
        }));
    }
}

