/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.utils.ClickType;
import io.github.pronze.lib.screaminglib.utils.ConfigurateUtils;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.simpleinventories.builder.InventorySetBuilder;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.events.OnTradeEvent;
import io.github.pronze.lib.simpleinventories.events.PreClickEvent;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Price;
import io.github.pronze.lib.simpleinventories.inventory.Property;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IStoreInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToDisplayedItem;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.utils.Sounds;

public abstract class AbstractStoreInventory
implements IStoreInventory,
Listener {
    private final Map<String, InventorySet> shopMap = new HashMap<String, InventorySet>();
    @NotNull
    private final String shopPaths;

    @OnPostEnable
    public void onPostEnable() {
        Arrays.stream(this.shopPaths.split(",")).forEach(path -> {
            File shopFile = SBA.getPluginInstance().getDataFolder().toPath().resolve((String)path).toFile();
            if (!shopFile.exists()) {
                SBA.getInstance().saveResource((String)path, false);
            }
        });
        SBA.getInstance().registerListener(this);
        this.loadNewShop("default", null, true);
    }

    public Optional<InventorySet> getInventory(String key) {
        return Optional.ofNullable(this.shopMap.get(key));
    }

    @Override
    public void openForPlayer(@NotNull SBAPlayerWrapper player, @NotNull GameStore store) {
        try {
            boolean parent = true;
            parent = store.getUseParent();
            String fileName = store.getShopFile();
            if (fileName != null) {
                File file;
                String name = (parent ? "+" : "-") + (file = ShopUtil.normalizeShopFile(fileName)).getAbsolutePath();
                if (!this.shopMap.containsKey(name)) {
                    this.loadNewShop(name, file, parent);
                }
                player.openInventory(this.shopMap.get(name));
            } else {
                player.openInventory(this.shopMap.get("default"));
            }
        }
        catch (Throwable ignored) {
            Logger.error("[SBA] Your shop is invalid! Check it out or contact us on Discord. {}", ignored);
            player.sendMessage("[SBA] Your shop is invalid! Check it out or contact us on Discord.");
        }
    }

    @Override
    public void loadNewShop(@NotNull String name, @Nullable File file, boolean useParent) {
        InventorySet inventorySet = ((InventorySetBuilder)this.getInventorySetBuilder().genericShop(true).genericShopPriceTypeRequired(true).animationsEnabled(true).call(categoryBuilder -> {
            Object pathStr = SBA.getPluginInstance().getDataFolder().getAbsolutePath();
            pathStr = (String)pathStr + "/" + (String)(file != null ? "shops/" + file.getName() : this.shopPaths.split(",")[0]);
            categoryBuilder.include(Include.of(Paths.get((String)pathStr, new String[0])));
        })).preClick(this::onPreAction).buy(this::onShopTransaction).render(this::onGeneratingItem).getInventorySet();
        try {
            inventorySet.getMainSubInventory().process();
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Wrong shop.yml configuration!");
            Bukkit.getLogger().warning("Check validity of your YAML!");
            ex.printStackTrace();
        }
        this.shopMap.put(name, inventorySet);
    }

    private void loadDefault(InventorySet inventorySet) {
        inventorySet.getMainSubInventory().dropContents();
        inventorySet.getMainSubInventory().getWaitingQueue().add(Include.of(Path.of(Objects.requireNonNull(SBA.class.getResource("/" + this.shopPaths.split(",")[0])).toURI())));
        inventorySet.getMainSubInventory().process();
    }

    private void onShopTransaction(OnTradeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.handlePrePurchase(event);
    }

    private void onPreAction(PreClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer().as(Player.class);
        if (!Main.isPlayerInGame((Player)player)) {
            event.setCancelled(true);
        }
        if (Main.getPlayerGameProfile((Player)player).isSpectator) {
            event.setCancelled(true);
        }
    }

    public void handlePrePurchase(OnTradeEvent event) {
        Item materialItem;
        Player player = event.getPlayer().as(Player.class);
        Game game = Main.getInstance().getGameOfPlayer(player);
        ClickType clickType = event.getClickType();
        PlayerItemInfo itemInfo = event.getItem();
        Price price = event.getPrices().get(0);
        ItemSpawnerType type = Main.getSpawnerType((String)price.getCurrency().toLowerCase());
        ItemStack newItem = event.getStack().as(ItemStack.class);
        int amount = newItem.getAmount();
        int priceAmount = price.getAmount();
        int inInventory = 0;
        Optional<Property> currencyChanger = itemInfo.getFirstPropertyByName("currencyChanger");
        if (currencyChanger.isPresent()) {
            String changeItemToName = currencyChanger.get().getPropertyData().getString();
            if (changeItemToName == null) {
                return;
            }
            ItemSpawnerType changeItemType = Main.getSpawnerType((String)changeItemToName.toLowerCase());
            if (changeItemType == null) {
                return;
            }
            newItem = changeItemType.getStack();
        }
        int originalMaxStackSize = newItem.getType().getMaxStackSize();
        if (clickType.isShiftClick() && originalMaxStackSize > 1) {
            double priceOfOne = (double)priceAmount / (double)amount;
            for (ItemStack itemStack : player.getInventory().getStorageContents()) {
                if (itemStack == null || !itemStack.isSimilar(type.getStack())) continue;
                inInventory += itemStack.getAmount();
            }
            double maxStackSize = Main.getInstance().getConfig().getBoolean("sell-max-64-per-click-in-shop") ? Math.min((double)inInventory / priceOfOne, (double)originalMaxStackSize) : (double)inInventory / priceOfOne;
            int finalStackSize = (int)maxStackSize;
            if (finalStackSize > amount) {
                priceAmount = (int)(priceOfOne * (double)finalStackSize);
                newItem.setAmount(finalStackSize);
                amount = finalStackSize;
                newItem.setAmount(amount);
            }
        }
        if (!event.hasPlayerInInventory(materialItem = ItemFactory.build(type.getStack(priceAmount)).orElseThrow())) {
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean()) {
                LanguageService.getInstance().get(MessageKeys.CANNOT_BUY).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            return;
        }
        for (Property property : itemInfo.getProperties()) {
            if (!property.hasName()) continue;
            Map<?, ?> converted = ConfigurateUtils.raw(property.getPropertyData());
            if (!(converted instanceof Map)) {
                converted = ShopUtil.nullValuesAllowingMap("value", converted);
            }
            Map propertyData = converted;
            propertyData.putIfAbsent("name", property.getPropertyName());
            BedwarsApplyPropertyToBoughtItem applyEvent = new BedwarsApplyPropertyToBoughtItem(game, player, newItem, propertyData);
            Logger.trace("Calling event: {} for property: {}", applyEvent.getClass().getSimpleName(), property.getPropertyName());
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)applyEvent);
            newItem = applyEvent.getStack();
        }
        AtomicReference<ItemStack> newItemRef = new AtomicReference<ItemStack>(newItem);
        AtomicReference<Item> newMaterialItemRef = new AtomicReference<Item>(materialItem);
        Map.Entry<Boolean, Boolean> result = this.handlePurchase(player, newItemRef, newMaterialItemRef, itemInfo, (org.screamingsandals.bedwars.api.game.ItemSpawnerType)type);
        newItem = newItemRef.get();
        materialItem = newMaterialItemRef.get();
        Boolean shouldSellStack = result.getKey();
        Boolean shouldBuyStack = result.getValue();
        if (!shouldBuyStack.booleanValue() && !shouldSellStack.booleanValue()) {
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean()) {
                LanguageService.getInstance().get(MessageKeys.CANNOT_BUY).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            return;
        }
        if (shouldBuyStack.booleanValue()) {
            this.buyStack(newItem, player);
        }
        if (shouldSellStack.booleanValue()) {
            event.sellStack(materialItem);
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean()) {
                LanguageService.getInstance().get(MessageKeys.SHOP_PURCHASE_SUCCESS).replace("%item%", ShopUtil.getNameOrCustomNameOfItem(ItemFactory.build(newItem).orElseThrow())).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            Sounds.playSound((Player)player, (Location)player.getLocation(), (String)Main.getConfigurator().config.getString("sounds.item_buy.sound"), (Sounds)Sounds.ENTITY_ITEM_PICKUP, (float)((float)Main.getConfigurator().config.getDouble("sounds.item_buy.volume")), (float)((float)Main.getConfigurator().config.getDouble("sounds.item_buy.pitch")));
        }
    }

    private void buyStack(ItemStack newItem, Player player) {
        HashMap noFit = player.getInventory().addItem(new ItemStack[]{newItem});
        if (!noFit.isEmpty()) {
            noFit.forEach((i, stack) -> player.getLocation().getWorld().dropItem(player.getLocation(), stack));
        }
    }

    private void onGeneratingItem(ItemRenderEvent event) {
        List<Price> prices;
        this.onPreGenerateItem(event);
        PlayerItemInfo itemInfo = event.getItem();
        Item item = itemInfo.getStack();
        Player player = event.getPlayer().as(Player.class);
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (itemInfo.getStack().getMaterial().is((Object)Material.POTION)) {
            ItemStack itemB = item.as(ItemStack.class);
            Logger.trace("{}", itemB);
        }
        if (!(prices = itemInfo.getOriginal().getPrices()).isEmpty()) {
            Price priceObject = prices.get(0);
            int price = priceObject.getAmount();
            ItemSpawnerType type = Main.getSpawnerType((String)priceObject.getCurrency().toLowerCase());
            if (type == null) {
                return;
            }
            item = ShopUtil.setLore(item, itemInfo, String.valueOf(price), (org.screamingsandals.bedwars.api.game.ItemSpawnerType)type, player);
            event.setStack(item);
        }
        event.setStack(item);
        itemInfo.getProperties().forEach(property -> {
            if (property.hasName()) {
                Map<?, ?> converted = ConfigurateUtils.raw(property.getPropertyData());
                if (!(converted instanceof Map)) {
                    converted = ShopUtil.nullValuesAllowingMap("value", converted);
                }
                Map propertyData = converted;
                propertyData.putIfAbsent("name", property.getPropertyName());
                BedwarsApplyPropertyToDisplayedItem applyEvent = new BedwarsApplyPropertyToDisplayedItem(game, player, event.getStack().as(ItemStack.class), propertyData);
                Bukkit.getServer().getPluginManager().callEvent((Event)applyEvent);
                event.setStack(ItemFactory.build(applyEvent.getStack()).orElse(event.getStack()));
            }
        });
        this.onPostGenerateItem(event);
    }

    public abstract void onPostGenerateItem(ItemRenderEvent var1);

    public abstract void onPreGenerateItem(ItemRenderEvent var1);

    public abstract Map.Entry<Boolean, Boolean> handlePurchase(Player var1, AtomicReference<ItemStack> var2, AtomicReference<Item> var3, PlayerItemInfo var4, org.screamingsandals.bedwars.api.game.ItemSpawnerType var5);

    @NotNull
    public abstract InventorySetBuilder getInventorySetBuilder();

    public AbstractStoreInventory(@NotNull String shopPaths) {
        if (shopPaths == null) {
            throw new NullPointerException("shopPaths is marked non-null but is null");
        }
        this.shopPaths = shopPaths;
    }
}

