/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.builder.InventorySetBuilder;
import io.github.pronze.lib.simpleinventories.events.PostClickEvent;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Property;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAGamesInventoryOpenEvent;
import io.github.pronze.sba.lang.Message;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.ShopUtil;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;

@Service(dependsOn={SBAConfig.class, SimpleInventoriesCore.class})
public class GamesInventory
implements Listener {
    private static final HashMap<Integer, String> labels = new HashMap<Integer, String>(){
        {
            this.put(1, "solo");
            this.put(2, "double");
            this.put(3, "triple");
            this.put(4, "squad");
        }
    };
    private final HashMap<Integer, InventorySet> inventoryMap = new HashMap();

    public static GamesInventory getInstance() {
        return ServiceManager.get(GamesInventory.class);
    }

    @OnPostEnable
    public void loadInventory() {
        try {
            labels.forEach((val, label) -> {
                try {
                    InventorySet siFormat = ((InventorySetBuilder)((InventorySetBuilder)SimpleInventoriesCore.builder().categoryOptions(localOptionsBuilder -> {
                        ShopUtil.generateOptions(localOptionsBuilder);
                        localOptionsBuilder.prefix(LanguageService.getInstance().get("games-inventory", "gui", label.toLowerCase() + "-prefix").toString());
                    })).call(categoryBuilder -> {
                        try {
                            String pathStr = SBA.getPluginInstance().getDataFolder().getAbsolutePath() + "/games-inventory/" + label.toLowerCase() + ".yml";
                            categoryBuilder.include(Include.of(Paths.get(pathStr, new String[0])));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    })).click(this::onClick).process().getInventorySet();
                    this.inventoryMap.put((Integer)val, siFormat);
                    Logger.trace("Successfully loaded games inventory for: {}", label);
                }
                catch (Throwable t) {
                    Logger.trace("Could not initialize games inventory format for {}", label);
                    t.printStackTrace();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void openForPlayer(Player player, int mode) {
        SBAGamesInventoryOpenEvent event = new SBAGamesInventoryOpenEvent(player, mode);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        InventorySet format = this.inventoryMap.get(mode);
        if (format != null) {
            PlayerMapper.wrapPlayer(player).openInventory(format);
        }
    }

    public static List<Game> getGamesWithSize(int size) {
        return Main.getGameNames().stream().map(g -> Main.getGame((String)g)).filter(g -> g.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == size)).collect(Collectors.toList());
    }

    public void onClick(PostClickEvent event) {
        Integer mode = this.inventoryMap.keySet().stream().filter(key -> event.getFormat() == this.inventoryMap.get(key)).findFirst().orElse(1);
        PlayerItemInfo item = event.getItem();
        Item stack = item.getStack();
        Player player = event.getPlayer().as(Player.class);
        List<Property> properties = item.getProperties();
        if (stack != null && item.hasProperties()) {
            Message couldNotFindGameMessage = LanguageService.getInstance().get(MessageKeys.GAMES_INVENTORY_CANNOT_FIND_GAME);
            PlayerWrapper playerWrapper = PlayerMapper.wrapPlayer(player);
            player.closeInventory();
            properties.stream().filter(Property::hasName).forEach(property -> {
                switch (property.getPropertyName().toLowerCase()) {
                    case "exit": {
                        break;
                    }
                    case "randomly_join": {
                        List<Game> games = GamesInventory.getGamesWithSize(mode);
                        if (games == null || games.isEmpty()) {
                            couldNotFindGameMessage.send(playerWrapper);
                            return;
                        }
                        Random r = new Random();
                        games.sort(Comparator.comparing(c -> ((Game)c).getConnectedPlayers().size()).reversed().thenComparing(c -> r.nextInt()));
                        games.stream().filter(game -> game.getStatus() == GameStatus.WAITING).findAny().ifPresentOrElse(game -> game.joinToGame(player), () -> couldNotFindGameMessage.send(playerWrapper));
                        break;
                    }
                    case "rejoin": {
                        player.performCommand("bw rejoin");
                        break;
                    }
                    case "join": {
                        String gameName = item.getFirstPropertyByName("join").orElseThrow().getPropertyData().node("gameName").getString();
                        if (gameName == null) {
                            couldNotFindGameMessage.send(playerWrapper);
                            return;
                        }
                        Main.getInstance().getGameByName(gameName).joinToGame(player);
                        break;
                    }
                }
            });
        }
    }
}

