/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.simpleinventories.SimpleInventoriesCore;
import io.github.pronze.lib.simpleinventories.builder.InventorySetBuilder;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.StoreType;
import io.github.pronze.sba.inventories.AbstractStoreInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.game.GameStore;

@Service(dependsOn={SimpleInventoriesCore.class})
public class SBAStoreInventory
extends AbstractStoreInventory {
    public static SBAStoreInventory getInstance() {
        return ServiceManager.get(SBAStoreInventory.class);
    }

    public SBAStoreInventory() {
        super("shops/shop.yml");
    }

    private void loadDefault(InventorySet inventorySet) {
        inventorySet.getMainSubInventory().dropContents();
        inventorySet.getMainSubInventory().getWaitingQueue().add(Include.of(Path.of(SBAStoreInventory.class.getResource("/shops/shop.yml").toURI())));
        inventorySet.getMainSubInventory().process();
    }

    @Override
    public void onPostGenerateItem(ItemRenderEvent event) {
        event.setStack(ShopUtil.applyTeamUpgradeEnchantsToItem(event.getStack(), event, StoreType.NORMAL));
    }

    @Override
    public void onPreGenerateItem(ItemRenderEvent event) {
    }

    @Override
    public Map.Entry<Boolean, Boolean> handlePurchase(Player player, AtomicReference<ItemStack> newItem, AtomicReference<Item> materialItem, PlayerItemInfo itemInfo, ItemSpawnerType type) {
        Game game = Main.getInstance().getGameOfPlayer(player);
        IGameStorage gameStorage = SBA.getInstance().getGameStorage(game).orElseThrow();
        String typeName = newItem.get().getType().name();
        RunningTeam team = game.getTeamOfPlayer(player);
        String afterUnderscore = typeName.substring(typeName.contains("_") ? typeName.indexOf("_") + 1 : 0);
        switch (afterUnderscore.toLowerCase()) {
            case "sword": {
                Integer sharpness = gameStorage.getSharpnessLevel(team).orElseThrow();
                if (sharpness > 0 && sharpness < 5) {
                    newItem.get().addEnchantment(Enchantment.DAMAGE_ALL, sharpness.intValue());
                }
                if (!SBAConfig.getInstance().node("replace-sword-on-upgrade").getBoolean(true)) break;
                Arrays.stream((ItemStack[])player.getInventory().getContents().clone()).filter(Objects::nonNull).filter(itemStack -> itemStack.getType().name().endsWith("SWORD")).filter(itemStack -> !itemStack.isSimilar((ItemStack)newItem.get())).forEach(sword -> player.getInventory().removeItem(new ItemStack[]{sword}));
                break;
            }
            case "boots": 
            case "chestplate": 
            case "helmet": 
            case "leggings": {
                return Map.entry(ShopUtil.buyArmor(player, newItem.get().getType(), gameStorage, game), false);
            }
            case "pickaxe": {
                Integer efficiency = gameStorage.getEfficiencyLevel(team).orElseThrow();
                if (efficiency <= 0 || efficiency >= 5) break;
                newItem.get().addEnchantment(Enchantment.DIG_SPEED, efficiency.intValue());
            }
        }
        return Map.entry(true, true);
    }

    @Override
    @NotNull
    public InventorySetBuilder getInventorySetBuilder() {
        return SimpleInventoriesCore.builder().categoryOptions(localOptionsBuilder -> localOptionsBuilder.backItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "normal-shop", "shopback"), "BARRIER"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_BACK).toComponent())).pageBackItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "normal-shop", "pageback"), "ARROW"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_BACK).toComponent())).pageForwardItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "normal-shop", "pageforward"), "BARRIER"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_FORWARD).toComponent())).cosmeticItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "normal-shop", "shopcosmetic"), "GRAY_STAINED_GLASS_PANE")).rows(SBAConfig.getInstance().node("shop", "normal-shop", "rows").getInt(6)).renderActualRows(SBAConfig.getInstance().node("shop", "normal-shop", "render-actual-rows").getInt(6)).renderOffset(SBAConfig.getInstance().node("shop", "normal-shop", "render-offset").getInt(0)).renderHeaderStart(SBAConfig.getInstance().node("shop", "normal-shop", "render-header-start").getInt(9)).renderFooterStart(SBAConfig.getInstance().node("shop", "normal-shop", "render-footer-start").getInt(600)).itemsOnRow(SBAConfig.getInstance().node("shop", "normal-shop", "items-on-row").getInt(9)).showPageNumber(SBAConfig.getInstance().node("shop", "normal-shop", "show-page-numbers").getBoolean(false)).inventoryType(SBAConfig.getInstance().node("shop", "normal-shop", "inventory-type").getString("CHEST")).prefix(LanguageService.getInstance().get(MessageKeys.SHOP_NAME).toComponent()));
    }

    @EventHandler
    public void onBedWarsOpenShop(BedwarsOpenShopEvent event) {
        String shopFile = event.getStore().getShopFile();
        if ((shopFile != null && shopFile.equalsIgnoreCase("shop.yml") || event.getStore().getUseParent()) && SBAConfig.getInstance().node("shop", "normal-shop", "enabled").getBoolean()) {
            event.setResult(BedwarsOpenShopEvent.Result.DISALLOW_UNKNOWN);
            Logger.trace("Player: {} has opened store!", event.getPlayer().getName());
            this.openForPlayer(PlayerMapper.wrapPlayer(event.getPlayer()).as(SBAPlayerWrapper.class), (GameStore)event.getStore());
        }
    }
}

