/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.lib.lang;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.yaml.NodeStyle;
import io.github.pronze.lib.configurate.yaml.YamlConfigurationLoader;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lang.ILanguageService;
import io.github.pronze.sba.lang.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Service
public class LanguageService
implements ILanguageService {
    private static final List<String> validLocale = List.of("af", "ar", "ca", "cs", "da", "de", "el", "en", "es", "fi", "fr", "he", "hu", "it", "ja", "ko", "nl", "no", "pl", "pt", "pt-BR", "ro", "ru", "sr", "sv", "tr", "uk", "vi", "zh", "zh-CN");
    private String locale;
    private ConfigurationNode configurationNode;
    private ConfigurationNode fallbackNode;

    public static LanguageService getInstance() {
        return ServiceManager.get(LanguageService.class);
    }

    public LanguageService(JavaPlugin plugin) {
        this.load(plugin);
    }

    public void load(JavaPlugin plugin) {
        this.locale = SBAConfig.getInstance().node("locale").getString("en");
        if (!validLocale.contains(this.locale.toLowerCase())) {
            throw new UnsupportedOperationException("Invalid locale provided!");
        }
        try {
            Object pathStr = plugin.getDataFolder().getAbsolutePath();
            pathStr = (String)pathStr + "/languages/language_" + this.locale + ".yml";
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Paths.get((String)pathStr, new String[0]))).nodeStyle(NodeStyle.BLOCK).build();
            this.fallbackNode = this.configurationNode = loader.load();
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("There was an error loading language file!");
            ex.printStackTrace();
        }
    }

    @OnPostEnable
    public void postEnable() {
        try {
            File fallbackFile = new File(SBA.getPluginInstance().getDataFolder() + "/languages", "language_fallback.yml");
            if (fallbackFile.exists()) {
                fallbackFile.delete();
            }
            fallbackFile.createNewFile();
            try (InputStream input = LanguageService.class.getResourceAsStream("/languages/language_en.yml");
                 FileOutputStream output = new FileOutputStream(fallbackFile);){
                assert (input != null);
                input.transferTo(output);
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(fallbackFile)).nodeStyle(NodeStyle.BLOCK).build();
            this.fallbackNode = loader.load();
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("There was an error loading fallback language!");
            ex.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Message get(String ... arguments) {
        return this.get(false, arguments);
    }

    public Message get(boolean fallback, String ... arguments) {
        ConfigurationNode argumentNode = fallback ? this.fallbackNode.node(arguments) : this.configurationNode.node(arguments);
        try {
            if (argumentNode == null || argumentNode.empty()) {
                throw new UnsupportedOperationException("Could not find key for: " + Arrays.toString(arguments));
            }
            if (argumentNode.isList()) {
                return Message.of(argumentNode.getList(String.class));
            }
            return Message.of(List.of(Objects.requireNonNull(argumentNode.getString())));
        }
        catch (SerializationException | UnsupportedOperationException e) {
            if (fallback) {
                e.printStackTrace();
            }
            if (!fallback) {
                return this.get(true, arguments);
            }
            return Message.of(List.of("TRANSLATION FOR: " + Arrays.toString(arguments) + " NOT FOUND!"));
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public ConfigurationNode getFallbackNode() {
        return this.fallbackNode;
    }
}

