/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAFinalKillEvent;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPostRebuildingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsTargetBlockDestroyedEvent;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.lib.nms.entity.PlayerUtils;

@Service
public class BedWarsListener
implements Listener {
    private final Map<UUID, BukkitTask> runnableCache = new HashMap<UUID, BukkitTask>();

    @OnPostEnable
    public void registerListener() {
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onStarted(BedwarsGameStartedEvent e) {
        Logger.trace("SBA onStarted{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        IArena arena = ArenaManager.getInstance().createArena(game);
        ((Arena)arena).onGameStarted();
    }

    @EventHandler
    public void onBwReload(PluginEnableEvent event) {
        String pluginName = event.getPlugin().getName();
        if (pluginName.equalsIgnoreCase(Main.getInstance().getName())) {
            if (!SBA.getPluginInstance().isEnabled()) {
                return;
            }
            Logger.trace("Re registering listeners!", new Object[0]);
            List<Listener> listeners = SBA.getInstance().getRegisteredListeners();
            listeners.forEach(SBA.getInstance()::unregisterListener);
            listeners.forEach(SBA.getInstance()::registerListener);
            Logger.trace("Registration complete!", new Object[0]);
        }
    }

    @EventHandler
    public void onTargetBlockDestroyed(BedwarsTargetBlockDestroyedEvent e) {
        Logger.trace("SBA onTargetBlockDestroyed{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onTargetBlockDestroyed(e));
    }

    @EventHandler
    public void onPostRebuildingEvent(BedwarsPostRebuildingEvent e) {
        Logger.trace("SBA onPostRebuildingEvent{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onOver(e));
        ArenaManager.getInstance().removeArena(game);
    }

    @EventHandler
    public void onOver(BedwarsGameEndingEvent e) {
        Logger.trace("SBA onOver{}", e);
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> ((Arena)arena).onOver(e));
    }

    @EventHandler
    public void onBWLobbyJoin(BedwarsPlayerJoinedEvent e) {
        Logger.trace("SBA onBWLobbyJoin{}", e);
        final Player player = e.getPlayer();
        SBAPlayerWrapper wrappedPlayer = SBA.getInstance().getPlayerWrapper(player);
        BukkitTask task = this.runnableCache.get(player.getUniqueId());
        final Game game = (Game)e.getGame();
        if (task != null) {
            SBAUtil.cancelTask(task);
        }
        SBA.getInstance().getPartyManager().getPartyOf(wrappedPlayer).ifPresent(party -> {
            if (!wrappedPlayer.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(wrappedPlayer);
                return;
            }
            if (party.getMembers().size() == 1) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NO_PLAYERS_TO_WARP).send(wrappedPlayer);
                return;
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send(wrappedPlayer);
            if (Main.getInstance().isPlayerPlayingAnyGame(player)) {
                party.getMembers().stream().filter(member -> !wrappedPlayer.equals(member)).forEach(member -> {
                    org.screamingsandals.bedwars.api.game.Game memberGame = Main.getInstance().getGameOfPlayer(member.getInstance());
                    Bukkit.getScheduler().runTask((Plugin)SBA.getPluginInstance(), () -> {
                        if (game != memberGame) {
                            if (memberGame != null) {
                                memberGame.leaveFromGame(member.getInstance());
                            }
                            game.joinToGame(member.getInstance());
                            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send((CommandSenderWrapper)member);
                        }
                    });
                });
            } else {
                Location leaderLocation = wrappedPlayer.getInstance().getLocation();
                party.getMembers().stream().filter(member -> !member.equals(player)).forEach(member -> {
                    if (Main.getInstance().isPlayerPlayingAnyGame(member.getInstance())) {
                        Main.getInstance().getGameOfPlayer(member.getInstance()).leaveFromGame(member.getInstance());
                    }
                    PlayerUtils.teleportPlayer((Player)member.getInstance(), (Location)leaderLocation);
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_LEADER_JOIN_LEAVE).send(PlayerMapper.wrapPlayer(member.getInstance()));
                });
            }
        });
        switch (game.getStatus()) {
            case WAITING: {
                BukkitTask bukkitTask = new BukkitRunnable(){
                    int buffer = 1;

                    public void run() {
                        if (game.getStatus() == GameStatus.WAITING) {
                            String time;
                            if (game.getConnectedPlayers().size() >= game.getMinPlayers() && !(time = game.getFormattedTimeLeft()).contains("0-1")) {
                                String[] units = time.split(":");
                                int seconds = Integer.parseInt(units[1]) + 1 + Integer.parseInt(units[0]) * 60;
                                if (this.buffer == seconds) {
                                    return;
                                }
                                this.buffer = seconds;
                                if (seconds <= 10) {
                                    String message = LanguageService.getInstance().get(MessageKeys.GAME_STARTS_IN_MESSAGE).replace("%seconds%", seconds <= 60 ? String.valueOf(seconds) : game.getFormattedTimeLeft()).toString();
                                    message = seconds == 1 ? message.replace("seconds", "second") : message;
                                    player.sendMessage(message);
                                    SBAUtil.sendTitle(PlayerMapper.wrapPlayer(player), ShopUtil.translateColors("&c" + seconds), "", 0, 20, 0);
                                }
                            }
                        } else {
                            this.cancel();
                            BedWarsListener.this.runnableCache.remove(player.getUniqueId());
                        }
                    }
                }.runTaskTimer((Plugin)SBA.getPluginInstance(), 3L, 20L);
                this.runnableCache.put(player.getUniqueId(), bukkitTask);
                break;
            }
            case RUNNING: {
                IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
                arena.getScoreboardManager().createScoreboard(player);
                ((Arena)arena).getRotatingGenerators().forEach(generator -> generator.addViewer(player));
            }
        }
    }

    @EventHandler
    public void onBedWarsPlayerLeave(BedwarsPlayerLeaveEvent e) {
        Logger.trace("SBA EonBedWarsPlayerLeave{}", e);
        Player player = e.getPlayer();
        BukkitTask task = this.runnableCache.get(player.getUniqueId());
        org.screamingsandals.bedwars.api.game.Game game = e.getGame();
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> {
            arena.removeVisualsForPlayer(player);
            arena.removePlayerFromGame(player);
        });
        if (task != null) {
            SBAUtil.cancelTask(task);
        }
        this.runnableCache.remove(player.getUniqueId());
        ScoreboardManager.getInstance().fromCache(player.getUniqueId()).ifPresent(Scoreboard::destroy);
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedWarsPlayerRespawnEvent(PlayerRespawnEvent e) {
        Player victim = e.getPlayer();
        if (!Main.isPlayerInGame((Player)victim)) {
            return;
        }
        org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(victim);
        Tasker.build(() -> ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> arena.addVisualsForPlayer(victim))).afterOneTick().start();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBedwarsPlayerPlay(PlayerGameModeChangeEvent e) {
        Player player = e.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        Logger.trace("Bedwars player {} changed gamemode from {} to {} ", player.getName(), player.getGameMode(), e.getNewGameMode());
        if (player.getGameMode() == GameMode.SURVIVAL) {
            Logger.trace("Ignoring gamemode change as they were already playing", player);
            return;
        }
        if (e.getNewGameMode() != GameMode.SURVIVAL) {
            Logger.trace("Ignoring gamemode change as they did not respawn", player);
            return;
        }
        Logger.trace("Player {} started playing", player);
        Tasker.build(() -> {
            org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(player);
            ShopUtil.applyTeamUpgrades(player, game);
        }).delay(2L, TaskerTime.TICKS).start();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedWarsPlayerKilledEvent(PlayerDeathEvent e) {
        Player victim = e.getEntity();
        if (!Main.isPlayerInGame((Player)victim)) {
            return;
        }
        Logger.trace("SBA ENTITY DIED :: {}", victim.getEntityId());
        org.screamingsandals.bedwars.api.game.Game game = Main.getInstance().getGameOfPlayer(victim);
        ArenaManager.getInstance().get(game.getName()).ifPresent(arena -> {
            arena.removeVisualsForPlayer(victim);
            arena.getPlayerData(victim.getUniqueId()).ifPresent(victimData -> victimData.setDeaths(victimData.getDeaths() + 1));
            Player killer = victim.getKiller();
            if (killer != null) {
                Logger.trace("Killer: {} has killed Player: {}", killer.getName(), victim.getName());
                GamePlayer gVictim = Main.getPlayerGameProfile((Player)victim);
                if (gVictim == null || gVictim.isSpectator) {
                    return;
                }
                RunningTeam victimTeam = game.getTeamOfPlayer(victim);
                if (victimTeam != null) {
                    arena.getPlayerData(killer.getUniqueId()).ifPresent(killerData -> {
                        Logger.trace("Incrementing killer kills to: {}", killerData.getKills() + 1);
                        killerData.setKills(killerData.getKills() + 1);
                        if (!victimTeam.isAlive()) {
                            killerData.setFinalKills(killerData.getFinalKills() + 1);
                            Bukkit.getPluginManager().callEvent((Event)new SBAFinalKillEvent(game, victim, killer));
                            if (SBAConfig.getInstance().node("final-kill-lightning").getBoolean(true)) {
                                victim.getWorld().strikeLightningEffect(victim.getLocation());
                            }
                        }
                    });
                }
            }
        });
    }
}

