/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;
import org.screamingsandals.bedwars.Main;

@Service
public class ExplosionVelocityControlListener
implements Listener {
    private final Set<Player> explosionAffectedPlayers = new HashSet<Player>();

    @OnPostEnable
    public void postEnable() {
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        Entity entity;
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && (entity = event.getEntity()) instanceof Player && this.explosionAffectedPlayers.contains(player = (Player)entity)) {
            event.setDamage(SBAConfig.getInstance().node("tnt-fireball-jumping", "fall-damage").getDouble(3.0));
            this.explosionAffectedPlayers.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExplode(EntityDamageByEntityEvent event) {
        Entity explodedEntity = event.getDamager();
        if (explodedEntity instanceof Explosive) {
            double detectionDistance = SBAConfig.getInstance().node("tnt-fireball-jumping", "detection-distance").getDouble(5.0);
            explodedEntity.getWorld().getNearbyEntities(explodedEntity.getLocation(), detectionDistance, detectionDistance, detectionDistance).stream().filter(entity -> !entity.equals(explodedEntity)).forEach(entity -> {
                Vector vector = explodedEntity.getLocation().clone().add(0.0, SBAConfig.getInstance().node("tnt-fireball-jumping", "acceleration-y").getDouble(1.0), 0.0).toVector().subtract(explodedEntity.getLocation().toVector()).normalize();
                vector.setY(vector.getY() / SBAConfig.getInstance().node("tnt-fireball-jumping", "reduce-y").getDouble(2.0));
                vector.multiply(SBAConfig.getInstance().node("tnt-fireball-jumping", "launch-multiplier").getDouble(4.0));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.getGameMode() == GameMode.SPECTATOR || !Main.isPlayerInGame((Player)player)) {
                        return;
                    }
                    vector.add(new Vector(player.getEyeLocation().getDirection().getX(), 0.0, player.getEyeLocation().getDirection().getZ()));
                    player.setVelocity(vector);
                    this.explosionAffectedPlayers.add(player);
                    return;
                }
                if (Main.getInstance().isEntityInGame(entity)) {
                    entity.setVelocity(vector);
                }
            });
        }
    }
}

