/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.screaminglib.hologram.Hologram;
import io.github.pronze.lib.screaminglib.hologram.HologramManager;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetPlayerTeamPacket;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.visuals.LocatableVisual;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.utils.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.AdminCommand;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GameCreator;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawner;

@Service
public class GameModeListener
implements Listener {
    HashMap<String, GameCreator> creators;
    HashMap<String, VisualRunnable> bkRun = new HashMap();

    @OnPostEnable
    public void onPostEnable() {
        SBA.getInstance().registerListener(this);
        for (BaseCommand cmd : Main.getCommands().values()) {
            if (!(cmd instanceof AdminCommand)) continue;
            this.creators = ((AdminCommand)cmd).gc;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        for (VisualRunnable runn : this.bkRun.values()) {
            runn.playerMoved(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        for (VisualRunnable runn : this.bkRun.values()) {
            runn.playerMoved(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeave(PlayerTeleportEvent event) {
        for (VisualRunnable runn : this.bkRun.values()) {
            runn.playerMoved(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent event) {
        for (VisualRunnable runn : this.bkRun.values()) {
            runn.playerDisconnect(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPreviewCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage();
        String[] arguments = message.split(" ");
        if (arguments.length >= 4 && this.isBedwarsAdminCommand(arguments)) {
            final String arenaName = arguments[2];
            final String action = arguments[3];
            Boolean editingHoloEnabled = SBAConfig.getInstance().getBoolean("editing-hologram-enabled", false);
            Logger.trace("editingHoloEnabled:{}", editingHoloEnabled);
            if (editingHoloEnabled.booleanValue()) {
                new BukkitRunnable(){

                    public void run() {
                        if (action.equals("save") && !GameModeListener.this.creators.containsKey(arenaName) && GameModeListener.this.bkRun.containsKey(arenaName)) {
                            Logger.trace("Arena " + arenaName + " saved", new Object[0]);
                            Optional.of(GameModeListener.this.bkRun.remove(arenaName)).ifPresent(r -> r.cancel());
                        }
                        if ((action.equals("edit") || action.equals("add")) && GameModeListener.this.creators.containsKey(arenaName) && !GameModeListener.this.bkRun.containsKey(arenaName)) {
                            Logger.trace("Arena " + arenaName + " is now in edit mode ", new Object[0]);
                            GameModeListener.this.startHolograms(arenaName);
                        }
                    }
                }.runTaskLater((Plugin)SBA.getPluginInstance(), 5L);
            }
        }
    }

    private void startHolograms(String arenaName) {
        VisualRunnable runnable = new VisualRunnable();
        runnable.setArena(this.creators.get(arenaName));
        runnable.runTaskTimer((Plugin)SBA.getPluginInstance(), 20L, 20L);
        this.bkRun.put(arenaName, runnable);
    }

    private boolean isBedwarsCommand(@NotNull String[] arguments) {
        String shortened = arguments[0].toLowerCase();
        return List.of("/bw", "/bedwars", "/bedwars:bw", "/bedwars:bedwars").stream().anyMatch(shortened::equals);
    }

    private boolean isBedwarsAdminCommand(@NotNull String[] arguments) {
        if (!this.isBedwarsCommand(arguments)) {
            return false;
        }
        if (arguments.length < 2) {
            return false;
        }
        String shortened = arguments[1].toLowerCase();
        return shortened.equals("admin");
    }

    private class VisualRunnable
    extends BukkitRunnable {
        Map<ItemSpawner, Hologram> holograms = new HashMap<ItemSpawner, Hologram>();
        Map<GameStore, NPC> npcs = new HashMap<GameStore, NPC>();
        Map<String, GameStore> villagerStores;
        Game game;

        private VisualRunnable() {
        }

        public void setArena(GameCreator gameCreator) {
            this.game = gameCreator.getGame();
            Logger.trace("Starting editing holograms for game {}", this.game.getName());
            this.villagerStores = (Map)Reflect.getField((Object)gameCreator, "villagerstores");
        }

        public void playerMoved(@NotNull Player player) {
            this.npcs.values().forEach(n -> n.removeViewer(PlayerMapper.wrapPlayer(player)));
            this.holograms.values().forEach(h -> h.removeViewer(PlayerMapper.wrapPlayer(player)));
            Tasker.build(() -> {
                for (NPC npc : this.npcs.values()) {
                    if (npc.location().getWorld().getName() != player.getWorld().getName()) continue;
                    npc.addViewer(PlayerMapper.wrapPlayer(player));
                }
                for (Hologram holo : this.holograms.values()) {
                    if (holo.location().getWorld().getName() != player.getWorld().getName()) continue;
                    holo.addViewer(PlayerMapper.wrapPlayer(player));
                }
            }).afterOneTick().start();
        }

        public void playerDisconnect(@NotNull Player player) {
            this.holograms.values().forEach(h -> h.removeViewer(PlayerMapper.wrapPlayer(player)));
            this.npcs.values().forEach(n -> n.removeViewer(PlayerMapper.wrapPlayer(player)));
        }

        private NPC addNpcAt(Location l, String name) {
            if (name == null) {
                name = "shop.yml";
            }
            NPC npc = (NPC)NPC.of(LocationMapper.wrapLocation(l)).lookAtPlayer(true).displayName(List.of(Component.text(name).color(TextColor.color(139, 69, 19)))).collisionRule(SClientboundSetPlayerTeamPacket.CollisionRule.NEVER).show();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (l.getWorld() != p.getWorld()) continue;
                npc.addViewer(PlayerMapper.wrapPlayer(p));
            }
            return npc;
        }

        public void run() {
            for (GameStore store : this.villagerStores.values()) {
                if (this.npcs.containsKey(store)) continue;
                this.npcs.put(store, this.addNpcAt(store.getStoreLocation(), store.getShopCustomName() != null ? store.getShopCustomName() : store.getShopFile()));
            }
            for (Object spawners : this.game.getSpawners()) {
                if (this.holograms.containsKey(spawners)) continue;
                Hologram hologram = HologramManager.hologram(LocationMapper.wrapLocation(spawners.getLocation().clone()));
                hologram.show();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (spawners.getLocation().getWorld() != p.getWorld()) continue;
                    hologram.addViewer(PlayerMapper.wrapPlayer(p));
                }
                hologram.item(ItemFactory.build(spawners.getItemSpawnerType().getStack()).orElseThrow()).itemPosition(Hologram.ItemPosition.BELOW).rotationMode(Hologram.RotationMode.Y).rotationTime(Pair.of(1, TaskerTime.TICKS)).rotationIncrement(18.0f);
                this.holograms.put((ItemSpawner)spawners, hologram);
            }
            List keys = this.holograms.keySet().stream().collect(Collectors.toList());
            for (ItemSpawner itemSpawner : keys) {
                if (this.game.getSpawners().contains(itemSpawner)) continue;
                this.holograms.get(itemSpawner).destroy();
                this.holograms.remove(itemSpawner);
            }
            List keysNpc = this.npcs.keySet().stream().collect(Collectors.toList());
            for (GameStore store : keysNpc) {
                if (this.villagerStores.values().contains(store)) continue;
                this.npcs.get(store).destroy();
                this.npcs.remove(store);
            }
        }

        public synchronized void cancel() throws IllegalStateException {
            this.holograms.values().forEach(LocatableVisual::destroy);
            this.holograms.clear();
            this.npcs.values().forEach(LocatableVisual::destroy);
            this.npcs.clear();
            super.cancel();
        }
    }
}

