/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsResourceSpawnEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.utils.Sounds;

@Service
public class GeneratorSplitterListener
implements Listener {
    private static List<Material> allowedMaterials = new ArrayList<Material>();
    private static final String SPLITTER_HASH = "SPLITTABLE";

    @OnPostEnable
    public void onPostEnable() {
        if (Version.isVersion(1, 12)) {
            SBA.getInstance().registerListener(new GeneratorSplitterListener112());
        } else {
            SBA.getInstance().registerListener(new GeneratorSplitterListenerBefore112());
        }
        allowedMaterials = Objects.requireNonNull(SBAConfig.getInstance().node("generator-splitter", "allowed-materials").getList(String.class)).stream().map(matName -> Material.valueOf((String)matName.toUpperCase().trim())).collect(Collectors.toList());
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onResourceSpawn(BedwarsResourceSpawnEvent event) {
        ItemStack resource = event.getResource();
        if (allowedMaterials.contains(resource.getType())) {
            APIUtils.hashIntoInvisibleString((ItemStack)resource, (String)SPLITTER_HASH);
        }
    }

    public static void onPickup(Player player, Item item) {
        if (Main.isPlayerInGame((Player)player)) {
            Game game = Main.getInstance().getGameOfPlayer(player);
            RunningTeam playerTeam = game.getTeamOfPlayer(player);
            if (!APIUtils.unhashFromInvisibleString((ItemStack)item.getItemStack(), (String)SPLITTER_HASH)) {
                return;
            }
            GeneratorSplitterListener.removeHash(item.getItemStack(), SPLITTER_HASH);
            player.getWorld().getNearbyEntities(player.getLocation(), 3.0, 3.0, 3.0).stream().filter(entity -> !entity.equals(player)).filter(entity -> entity instanceof Player).map(entity -> (Player)entity).filter(Main::isPlayerInGame).forEach(nearbyPlayer -> {
                RunningTeam nearbyPlayerTeam = game.getTeamOfPlayer(nearbyPlayer);
                if (nearbyPlayerTeam == playerTeam) {
                    nearbyPlayer.getInventory().addItem(new ItemStack[]{item.getItemStack().clone()});
                    Sounds.playSound((Player)nearbyPlayer, (Location)nearbyPlayer.getLocation(), (String)"ENTITY_ITEM_PICKUP", (Sounds)Sounds.ENTITY_ITEM_PICKUP, (float)1.0f, (float)1.0f);
                }
            });
        }
    }

    public static void removeHash(ItemStack stack, String hash) {
        ItemMeta meta = stack.getItemMeta();
        try {
            NamespacedKey key = new NamespacedKey((Plugin)BedwarsAPI.getInstance(), "screaming-bedwars-hidden-api");
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.remove(key);
        }
        catch (Throwable ignored) {
            ArrayList<String> lore;
            ArrayList<String> arrayList = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.removeIf(GeneratorSplitterListener.convertToInvisibleString(hash)::equals);
            meta.setLore(lore);
        }
        stack.setItemMeta(meta);
    }

    private static String convertToInvisibleString(String s) {
        StringBuilder hidden = new StringBuilder();
        for (char c : s.toCharArray()) {
            hidden.append("\u00a7").append(c);
        }
        return hidden.toString();
    }

    private static class GeneratorSplitterListener112
    implements Listener {
        private GeneratorSplitterListener112() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPickup(EntityPickupItemEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            GeneratorSplitterListener.onPickup((Player)event.getEntity(), event.getItem());
        }
    }

    private static class GeneratorSplitterListenerBefore112
    implements Listener {
        private GeneratorSplitterListenerBefore112() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPickup(PlayerPickupItemEvent event) {
            GeneratorSplitterListener.onPickup(event.getPlayer(), event.getItem());
        }
    }
}

