/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.party;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.player.ExtendablePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.data.PartyInviteData;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class Party
implements IParty {
    @NotNull
    private SBAPlayerWrapper leader;
    private final UUID uuid;
    private final List<SBAPlayerWrapper> members;
    private final List<SBAPlayerWrapper> invitedPlayers;
    private final Map<UUID, PartyInviteData> inviteDataMap;
    private final PartySetting settings;

    public Party(@NotNull SBAPlayerWrapper leader) {
        this.leader = leader;
        this.uuid = UUID.randomUUID();
        this.members = new ArrayList<SBAPlayerWrapper>();
        this.invitedPlayers = new ArrayList<SBAPlayerWrapper>();
        this.inviteDataMap = new HashMap<UUID, PartyInviteData>();
        this.settings = new PartySetting();
        leader.getSettings().enable(PlayerSetting.IN_PARTY);
        this.members.add(leader);
        Logger.trace("Created party with leader: {}, party is: {}", leader.getName(), this.debugInfo());
    }

    @Override
    public List<SBAPlayerWrapper> getMembers() {
        return List.copyOf(this.members);
    }

    @Override
    public List<SBAPlayerWrapper> getInvitedPlayers() {
        return List.copyOf(this.invitedPlayers);
    }

    @Override
    public void sendMessage(@NotNull Component message, @NotNull SBAPlayerWrapper sender) {
        Logger.trace("Sending message: {} to party: {}", AdventureHelper.toLegacy(message), this.debugInfo());
        Component formattedMessage = LanguageService.getInstance().get(MessageKeys.PARTY_CHAT_FORMAT).replace("%name%", sender.getName()).replace("%message%", AdventureHelper.toLegacy(message)).toComponent();
        this.members.forEach(player -> PlayerMapper.wrapPlayer(player.getInstance()).sendMessage(formattedMessage));
    }

    @Override
    public void addPlayer(@NotNull SBAPlayerWrapper player) {
        PartyInviteData inviteData;
        Logger.trace("Adding player: {} to party: {}", player.getName(), this.debugInfo());
        this.invitedPlayers.remove(player);
        this.members.add(player);
        if (this.inviteDataMap.containsKey(player.getInstance().getUniqueId()) && (inviteData = this.inviteDataMap.get(player.getInstance().getUniqueId())) != null) {
            SBAUtil.cancelTask(inviteData.getInviteTask());
            player.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
            this.inviteDataMap.remove(player.getInstance().getUniqueId());
        }
    }

    @Override
    public void removePlayer(@NotNull SBAPlayerWrapper player) {
        Logger.trace("Removing player: {} from party: {}", player.getName(), this.debugInfo());
        this.members.remove(player);
        player.getSettings().disable(PlayerSetting.IN_PARTY);
    }

    @Override
    @NotNull
    public synchronized SBAPlayerWrapper getPartyLeader() {
        return this.leader;
    }

    @Override
    public synchronized void setPartyLeader(@NotNull SBAPlayerWrapper player) {
        if (player.equals(this.leader)) {
            return;
        }
        Logger.trace("Replacing leader: {} with: {} in party of uuid: {}", this.leader.getName(), player.getName(), this.debugInfo());
        this.leader = player;
        if (!this.members.contains(this.leader)) {
            this.members.add(this.leader);
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void invitePlayer(final @NotNull SBAPlayerWrapper invitee, @NotNull SBAPlayerWrapper player) {
        if (this.inviteDataMap.containsKey(invitee.getInstance().getUniqueId())) {
            return;
        }
        Logger.trace("Player: {} has invited: {} to party: {}", player.getName(), invitee.getName(), this.debugInfo());
        this.invitedPlayers.add(invitee);
        invitee.getSettings().enable(PlayerSetting.INVITED_TO_PARTY);
        BukkitTask inviteTask = new BukkitRunnable(){

            public void run() {
                Logger.trace("IParty invitation expired for: {} of party: {}", invitee.getName(), Party.this.debugInfo());
                invitee.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
                Party.this.inviteDataMap.remove(invitee.getInstance().getUniqueId());
                if (Party.this.shouldDisband()) {
                    SBA.getInstance().getPartyManager().disband(Party.this.uuid);
                    Logger.trace("Disbanding party: {}", Party.this.uuid);
                }
                if (Party.this.getPartyLeader().isOnline()) {
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_EXPIRED).send(Party.this.getPartyLeader());
                }
            }
        }.runTaskLater((Plugin)SBA.getPluginInstance(), 20L * (long)SBA.getInstance().getConfigurator().getInt("party.invite-expiration-time", 60).intValue());
        PartyInviteData inviteData = PartyInviteData.of(invitee, player, inviteTask);
        this.inviteDataMap.put(invitee.getInstance().getUniqueId(), inviteData);
    }

    @Override
    public boolean isInvited(@NotNull SBAPlayerWrapper player) {
        return this.inviteDataMap.containsKey(player.getInstance().getUniqueId());
    }

    @Override
    public boolean shouldDisband() {
        return this.getInvitedPlayers().size() == 0 && this.getMembers().size() <= 1;
    }

    @Override
    public void removeInvitedPlayer(@NotNull SBAPlayerWrapper invitee) {
        if (!this.invitedPlayers.contains(invitee)) {
            return;
        }
        this.invitedPlayers.remove(invitee);
        invitee.getSettings().disable(PlayerSetting.INVITED_TO_PARTY);
    }

    public List<PartyInviteData> getInviteData() {
        return List.copyOf(this.inviteDataMap.values());
    }

    public String toString() {
        return "Party{uuid=" + this.uuid + ", leader=" + this.leader.getName() + ", members=" + this.members.stream().map(ExtendablePlayerWrapper::getName).collect(Collectors.toList()).toString() + ", invitedPlayers=" + this.invitedPlayers.stream().map(ExtendablePlayerWrapper::getName).collect(Collectors.toList()).toString() + "}";
    }

    @Override
    public String debugInfo() {
        return "[leader=" + this.leader.getName() + ", uuid=" + this.uuid.toString() + "]";
    }

    @Override
    public synchronized PartySetting getSettings() {
        return this.settings;
    }
}

