/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.placeholderapi;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;

public class SBAExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "sba";
    }

    @NotNull
    public String getAuthor() {
        return "pronze";
    }

    @NotNull
    public String getVersion() {
        return SBA.getInstance().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        Logger.trace("Placeholder '" + identifier + "' was requested.", new Object[0]);
        String[] identifiers = identifier.split("_");
        if (identifiers.length <= 1) {
            return null;
        }
        if (identifiers[0].equalsIgnoreCase("player")) {
            if (player == null) {
                return "";
            }
            SBAPlayerWrapper database = PlayerWrapperService.getInstance().get(player).orElseThrow();
            switch (identifiers[1]) {
                case "level": {
                    return Integer.toString(database.getLevel());
                }
                case "xp": {
                    return Integer.toString(database.getXP());
                }
                case "progress": {
                    return Integer.toString(database.getIntegerProgress());
                }
            }
        } else if (identifiers[0].equalsIgnoreCase("game")) {
            if (identifiers.length <= 2) {
                return null;
            }
            Game game = Main.getInstance().getGameByName(identifiers[1]);
            switch (identifiers[2]) {
                case "status": {
                    return game.getStatus().toString();
                }
                case "teams": {
                    return Integer.toString(game.countRunningTeams());
                }
                case "players": {
                    return Integer.toString(game.countConnectedPlayers());
                }
                case "time": {
                    return Integer.toString(game.getArenaTime().time);
                }
                case "gametime": {
                    return Integer.toString(game.getGameTime());
                }
                case "minplayers": {
                    return Integer.toString(game.getMinPlayers());
                }
                case "maxplayers": {
                    return Integer.toString(game.getMaxPlayers());
                }
            }
        } else if (identifiers[0].equalsIgnoreCase("version")) {
            return SBA.getInstance().getVersion();
        }
        return super.onPlaceholderRequest(player, identifier);
    }
}

