/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.lib.screaminglib.event.OnEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerJoinEvent;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.npc.event.NPCInteractEvent;
import io.github.pronze.lib.screaminglib.npc.skin.NPCSkin;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.InteractType;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPreDisable;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.game.GameMode;
import io.github.pronze.sba.inventories.GamesInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.visuals.MainLobbyVisualsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Service(dependsOn={PlayerMapper.class, PlayerWrapperService.class})
public class GamesInventoryService
implements Listener {
    private final Map<Integer, Action> entityEditMap = new LinkedHashMap<Integer, Action>();
    private final Map<Integer, Object> entityEditMapArgument = new LinkedHashMap<Integer, Object>();
    private final List<NPCConfig> NPCs = new ArrayList<NPCConfig>();

    public static GamesInventoryService getInstance() {
        return ServiceManager.get(GamesInventoryService.class);
    }

    @OnPostEnable
    public void loadGamesInv() {
        SBA.getInstance().registerListener(this);
        File file = new File(SBA.getInstance().getDataFolder().resolve("games-inventory").toString(), "npc.yml");
        if (file.exists()) {
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            this.NPCs.stream().filter(npcc -> npcc.npc != null).forEach(npcc -> {
                npcc.npc.destroy();
                npcc.npc = null;
            });
            this.NPCs.clear();
            this.checkAndAdd(config, GameMode.SOLOS, new ArrayList<Location>());
            this.checkAndAdd(config, GameMode.DOUBLES, new ArrayList<Location>());
            this.checkAndAdd(config, GameMode.TRIPLES, new ArrayList<Location>());
            this.checkAndAdd(config, GameMode.SQUADS, new ArrayList<Location>());
            Logger.trace("Loaded old config files into {}", this.NPCs);
            config.getList("npcs").forEach(element -> {
                try {
                    LinkedHashMap npc_config = (LinkedHashMap)element;
                    NPCConfig cfg = new NPCConfig();
                    LinkedHashMap obj = (LinkedHashMap)npc_config.get("skin");
                    if (obj != null) {
                        cfg.skin = (String)obj.get("value");
                        cfg.skin_signature = (String)obj.get("signature");
                    }
                    cfg.location = (Location)npc_config.get("location");
                    cfg.mode = (Integer)npc_config.get("mode");
                    this.NPCs.add(cfg);
                }
                catch (Exception e) {
                    Logger.error("Could not read {}", e);
                }
            });
            this.NPCs.forEach(npc -> {
                Logger.trace("NPC at {} for mode {}", npc.location, npc.mode);
                NPC n = this.createNpc(GameMode.fromInt(npc.mode), npc.location);
                if (npc.skin != null) {
                    n.skin(new NPCSkin(npc.skin, npc.skin_signature));
                }
                npc.npc = n;
            });
            this.update();
        }
        Tasker.build(() -> Bukkit.getOnlinePlayers().forEach(player -> {
            if (MainLobbyVisualsManager.isInWorld(player.getLocation())) {
                this.addViewer(PlayerMapper.wrapPlayer(player));
            }
        })).delay(1L, TaskerTime.SECONDS).start();
    }

    private void checkAndAdd(YamlConfiguration config, GameMode mode, List<Location> locations) {
        Object node = config.get(mode.name().toLowerCase());
        if (node != null) {
            locations.clear();
            locations.addAll((List)node);
            locations.forEach(location -> {
                Logger.trace("Adding NPC at {} for mode {}", new Object[]{location, mode});
                NPCConfig cfg = new NPCConfig();
                cfg.location = location;
                cfg.mode = mode.intVal();
                this.NPCs.add(cfg);
            });
            locations.clear();
        }
        Logger.trace("Loaded gamemode {} into {}", new Object[]{mode, locations});
    }

    private NPC createNpc(GameMode mode, Location location) {
        return (NPC)NPC.of(LocationMapper.wrapLocation(location)).lookAtPlayer(true).displayName(LanguageService.getInstance().get(MessageKeys.GAMES_INV_DISPLAY_NAME).replace("%mode%", mode.strVal()).toComponentList()).show();
    }

    public void addNPC(@NotNull GameMode mode, @NotNull Location location) {
        NPC npc = this.createNpc(mode, location);
        NPCConfig cfg = new NPCConfig();
        cfg.location = location;
        cfg.mode = mode.intVal();
        cfg.npc = npc;
        this.NPCs.add(cfg);
        this.update();
    }

    public void removeNPC(PlayerWrapper remover, @NotNull NPC npc) {
        this.NPCs.stream().filter(n -> n.npc == npc).findAny().ifPresent(c -> {
            LanguageService.getInstance().get(MessageKeys.NPC_REMOVED).send(remover);
            c.npc.destroy();
            this.NPCs.remove(c);
            this.update();
        });
    }

    public void update() {
        try {
            File file = new File(SBA.getInstance().getDataFolder().resolve("games-inventory").toString(), "npc.yml");
            YamlConfiguration config = new YamlConfiguration();
            if (!file.exists()) {
                file.createNewFile();
            }
            ArrayList npcYaml = new ArrayList();
            this.NPCs.forEach(npc -> {
                YamlConfiguration oneNpc = new YamlConfiguration();
                oneNpc.set("location", (Object)npc.location);
                ConfigurationSection skin = oneNpc.createSection("skin");
                skin.set("value", (Object)npc.skin);
                skin.set("signature", (Object)npc.skin_signature);
                oneNpc.set("mode", (Object)npc.mode);
                npcYaml.add(oneNpc);
            });
            config.set("npcs", npcYaml);
            config.save(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addViewer(@NotNull PlayerWrapper player) {
        this.NPCs.forEach(npc -> npc.npc.addViewer(player));
    }

    public void removeViewer(@NotNull PlayerWrapper player) {
        this.NPCs.forEach(npc -> npc.npc.removeViewer(player));
    }

    @OnPreDisable
    public void destroy() {
        Logger.trace("Disabling Games inventory NPCs", new Object[0]);
        this.NPCs.forEach(npc -> {
            npc.npc.destroy();
            npc.npc = null;
        });
        this.update();
    }

    @OnEvent
    public void onPlayerJoin(SPlayerJoinEvent e) {
        PlayerWrapper player = e.player();
        Tasker.build(() -> {
            if (MainLobbyVisualsManager.isInWorld(player.getLocation().as(Location.class)) && player.isOnline()) {
                this.addViewer(player);
            }
        }).delay(1L, TaskerTime.SECONDS).start();
    }

    @OnPreDisable
    private void onDisable() {
        this.entityEditMap.clear();
    }

    public void addEditable(PlayerWrapper player, Action mode, Object argument) {
        if (this.entityEditMap.containsKey(player.as(Player.class).getEntityId())) {
            return;
        }
        this.entityEditMap.put(player.as(Player.class).getEntityId(), mode);
        this.entityEditMapArgument.put(player.as(Player.class).getEntityId(), argument);
        Tasker.build(() -> {
            this.entityEditMap.remove(player.as(Player.class).getEntityId());
            this.entityEditMapArgument.remove(player.as(Player.class).getEntityId());
        }).delay(5L, TaskerTime.SECONDS).start();
    }

    private void setNpcSkin(PlayerWrapper player, NPC visual) {
        String argument = (String)this.entityEditMapArgument.get(player.as(Player.class).getEntityId());
        NPCSkin.retrieveSkin(argument).whenComplete((skin, exp) -> {
            if (skin != null) {
                this.NPCs.stream().filter(n -> n.npc == visual).findAny().ifPresent(c -> {
                    visual.skin((NPCSkin)skin);
                    c.skin = skin.getValue();
                    c.skin_signature = skin.getSignature();
                    this.update();
                });
            } else {
                Logger.error("Unable to retreive skin of {}: {}", argument, exp);
            }
        });
    }

    @OnEvent
    public void onNPCTouch(final NPCInteractEvent event) {
        if (event.interactType() == InteractType.RIGHT_CLICK && this.entityEditMap.containsKey(event.player().as(Player.class).getEntityId())) {
            Action a = this.entityEditMap.get(event.player().as(Player.class).getEntityId());
            if (a == Action.Remove) {
                this.removeNPC(event.player(), (NPC)event.visual());
            } else if (a == Action.Skin) {
                this.setNpcSkin(event.player(), (NPC)event.visual());
            }
            return;
        }
        NPC clicked = (NPC)event.visual();
        this.NPCs.stream().filter(n -> n.npc == clicked).findAny().ifPresent(c -> new BukkitRunnable((NPCConfig)c){
            final /* synthetic */ NPCConfig val$c;
            {
                this.val$c = nPCConfig;
            }

            public void run() {
                GamesInventory.getInstance().openForPlayer(event.player().as(Player.class), this.val$c.mode);
            }
        }.runTask((Plugin)SBA.getPluginInstance()));
    }

    private class NPCConfig {
        public Location location;
        public String skin;
        public String skin_signature;
        public int mode;
        public NPC npc;

        private NPCConfig() {
        }
    }

    public static enum Action {
        Remove,
        Skin;

    }
}

