/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicator;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicatorManager;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPreDisable;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.game.Game;

@Service(dependsOn={HealthIndicatorManager.class})
public class HealthIndicatorService
implements Listener {
    private final Map<IArena, HealthIndicator> healthIndicatorMap = new HashMap<IArena, HealthIndicator>();
    private boolean tabEnabled;

    @OnPostEnable
    public void postEnabled() {
        this.tabEnabled = SBAConfig.getInstance().node("show-health-in-tablist").getBoolean();
        boolean tagEnabled = SBAConfig.getInstance().node("show-health-under-player-name").getBoolean();
        if (!tagEnabled) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @OnPreDisable
    public void onDestroy() {
        this.healthIndicatorMap.values().forEach(Visual::destroy);
        this.healthIndicatorMap.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGameStart(BedwarsGameStartedEvent event) {
        Game game = event.getGame();
        HealthIndicator healthIndicator = ((HealthIndicator)HealthIndicator.of().symbol(Component.text("\u2665", (TextColor)NamedTextColor.RED)).showHealthInTabList(this.tabEnabled).show()).startUpdateTask(2L, TaskerTime.TICKS);
        game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).forEach(healthIndicator::addViewer);
        game.getConnectedPlayers().stream().map(PlayerMapper::wrapPlayer).forEach(healthIndicator::addTrackedPlayer);
        this.healthIndicatorMap.put(ArenaManager.getInstance().get(game.getName()).orElseThrow(), healthIndicator);
    }

    @EventHandler
    public void onPlayerLeave(BedwarsPlayerLeaveEvent event) {
        PlayerWrapper playerWrapper = PlayerMapper.wrapPlayer(event.getPlayer());
        HealthIndicator healthIndicator = this.healthIndicatorMap.get(ArenaManager.getInstance().get(event.getGame().getName()).orElse(null));
        if (healthIndicator != null) {
            healthIndicator.removeViewer(playerWrapper);
            healthIndicator.removeTrackedPlayer(playerWrapper);
        }
    }

    @EventHandler
    public void onBedwarsGameEndingEvent(BedwarsGameEndingEvent event) {
        IArena arena = ArenaManager.getInstance().get(event.getGame().getName()).orElseThrow();
        HealthIndicator healthIndicator = this.healthIndicatorMap.get(arena);
        if (healthIndicator != null) {
            healthIndicator.destroy();
            this.healthIndicatorMap.remove(arena);
        }
    }
}

