/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.specials;

import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.sba.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;

public class PopupTower {
    private static final Map<BlockFace, Byte> faceToByte = Map.of(BlockFace.EAST, (byte)5, BlockFace.WEST, (byte)4, BlockFace.SOUTH, (byte)3, BlockFace.NORTH, (byte)2);
    private static final List<BlockFace> pillarSides = List.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH);
    private final Game game;
    private final Material material;
    private final Location centerPoint;
    private final BlockFace placementFace;
    private final List<Location> enterancelocation = new ArrayList<Location>();
    private List<Location> targetBlocks;

    public void createTower() {
        this.targetBlocks = this.game.getRunningTeams().stream().map(Team::getTargetBlock).collect(Collectors.toList());
        Block bottomRel = this.centerPoint.getBlock().getRelative(this.placementFace.getOppositeFace(), 2).getRelative(BlockFace.UP);
        this.enterancelocation.add(bottomRel.getLocation());
        this.enterancelocation.add(bottomRel.getRelative(BlockFace.UP).getLocation());
        Logger.trace("Placement face: {}", this.placementFace);
        this.placeAnimated(BlockFace.NORTH, BlockFace.WEST);
        this.placeAnimated(BlockFace.SOUTH, BlockFace.WEST);
        this.placeAnimated(BlockFace.WEST, BlockFace.SOUTH);
        this.placeAnimated(BlockFace.EAST, BlockFace.SOUTH);
        Tasker.build(() -> {
            Block secondPlatform = this.centerPoint.getBlock().getRelative(BlockFace.UP, 5);
            this.placeBlock(secondPlatform.getLocation(), this.material);
            pillarSides.forEach(blockFace -> this.placeBlock(secondPlatform.getRelative(blockFace).getLocation(), this.material));
            this.placeBlock(secondPlatform.getRelative(BlockFace.NORTH_WEST).getLocation(), this.material);
            this.placeBlock(secondPlatform.getRelative(BlockFace.NORTH_EAST).getLocation(), this.material);
            this.placeBlock(secondPlatform.getRelative(BlockFace.SOUTH_WEST).getLocation(), this.material);
            this.placeBlock(secondPlatform.getRelative(BlockFace.SOUTH_EAST).getLocation(), this.material);
            Block northWestCornerBlock = secondPlatform.getRelative(BlockFace.NORTH_WEST, 2).getRelative(BlockFace.UP);
            this.placeBlock(northWestCornerBlock.getRelative(BlockFace.DOWN).getLocation(), this.material);
            this.placeBlock(northWestCornerBlock.getRelative(BlockFace.WEST).getLocation(), this.material);
            this.placeBlock(northWestCornerBlock.getRelative(BlockFace.NORTH).getLocation(), this.material);
            this.placeBlock(northWestCornerBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getLocation(), this.material);
            this.placeBlock(northWestCornerBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getLocation(), this.material);
            Block northEastCornerBlock = secondPlatform.getRelative(BlockFace.NORTH_EAST, 2).getRelative(BlockFace.UP);
            this.placeBlock(northEastCornerBlock.getRelative(BlockFace.DOWN).getLocation(), this.material);
            this.placeBlock(northEastCornerBlock.getRelative(BlockFace.EAST).getLocation(), this.material);
            this.placeBlock(northEastCornerBlock.getRelative(BlockFace.NORTH).getLocation(), this.material);
            this.placeBlock(northEastCornerBlock.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getLocation(), this.material);
            this.placeBlock(northEastCornerBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getLocation(), this.material);
            Block southWestCornerBlock = secondPlatform.getRelative(BlockFace.SOUTH_WEST, 2).getRelative(BlockFace.UP);
            this.placeBlock(southWestCornerBlock.getRelative(BlockFace.DOWN).getLocation(), this.material);
            this.placeBlock(southWestCornerBlock.getRelative(BlockFace.WEST).getLocation(), this.material);
            this.placeBlock(southWestCornerBlock.getRelative(BlockFace.SOUTH).getLocation(), this.material);
            this.placeBlock(southWestCornerBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getLocation(), this.material);
            this.placeBlock(southWestCornerBlock.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getLocation(), this.material);
            Block southEastCornerBlock = secondPlatform.getRelative(BlockFace.SOUTH_EAST, 2).getRelative(BlockFace.UP);
            this.placeBlock(southEastCornerBlock.getRelative(BlockFace.DOWN).getLocation(), this.material);
            this.placeBlock(southEastCornerBlock.getRelative(BlockFace.EAST).getLocation(), this.material);
            this.placeBlock(southEastCornerBlock.getRelative(BlockFace.SOUTH).getLocation(), this.material);
            this.placeBlock(southEastCornerBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getLocation(), this.material);
            this.placeBlock(southEastCornerBlock.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getLocation(), this.material);
            this.placeRowAnimated(3, northWestCornerBlock.getRelative(BlockFace.NORTH).getLocation(), BlockFace.EAST, 1);
            this.placeRowAnimated(3, southWestCornerBlock.getRelative(BlockFace.SOUTH).getLocation(), BlockFace.EAST, 1);
            this.placeRowAnimated(4, southWestCornerBlock.getRelative(BlockFace.SOUTH_WEST).getLocation(), BlockFace.NORTH, 1);
            this.placeRowAnimated(4, southEastCornerBlock.getRelative(BlockFace.EAST).getLocation(), BlockFace.NORTH, 1);
            this.placeBlock(secondPlatform.getRelative(this.placementFace, 3).getRelative(BlockFace.UP, 2).getLocation(), this.material);
            this.placeBlock(secondPlatform.getRelative(this.placementFace.getOppositeFace(), 3).getRelative(BlockFace.UP, 2).getLocation(), this.material);
            Location firstLadderBlock = this.centerPoint.getBlock().getRelative(this.placementFace).getLocation();
            this.placeLadderRow(5, firstLadderBlock, BlockFace.UP, this.placementFace.getOppositeFace());
        }).delay(40L, TaskerTime.TICKS).start();
    }

    public void placeAnimated(BlockFace direction, BlockFace start) {
        Location p1 = this.centerPoint.getBlock().getRelative(direction, 2).getRelative(start, 2).getLocation();
        this.placeRowAndColumn(3, 5, p1, start.getOppositeFace());
    }

    public void placeRowAnimated(int length, Location loc, BlockFace face, int delay) {
        Location lastLoc = loc;
        for (int i = 0; i < length; ++i) {
            Location finalLastLoc = lastLoc = lastLoc.getBlock().getRelative(face).getLocation();
            Tasker.build(() -> this.placeBlock(finalLastLoc, this.material)).delay(++delay, TaskerTime.TICKS).start();
        }
    }

    public void placeRowAndColumn(int length, int height, Location loc, BlockFace face) {
        int sepTickedPlacement = 1;
        for (int i = 0; i < height; ++i) {
            Location finalLoc = loc = loc.clone().add(0.0, 1.0, 0.0);
            for (int j = 0; j < length; ++j) {
                this.placeRowAnimated(length, finalLoc, face, sepTickedPlacement);
                sepTickedPlacement += 2;
            }
        }
    }

    private boolean isTargetBlockNear(List<Location> targetBlocks, Location loc) {
        return targetBlocks.contains(loc) || Arrays.stream(BlockFace.values()).anyMatch(blockFace -> targetBlocks.contains(loc.getBlock().getRelative(blockFace, 1).getLocation()));
    }

    public void placeLadderRow(int length, Location loc, BlockFace face, BlockFace ladderFace) {
        if (this.game.getStatus() != GameStatus.RUNNING) {
            return;
        }
        Location lastLoc = loc;
        for (int i = 0; i < length; ++i) {
            lastLoc = lastLoc.getBlock().getRelative(face).getLocation();
            Block ladder = lastLoc.getBlock();
            if (!this.isLocationSafe(lastLoc)) continue;
            ladder.setType(Material.LADDER, false);
            this.game.getRegion().removeBlockBuiltDuringGame(lastLoc);
            this.game.getRegion().addBuiltDuringGame(lastLoc);
            if (!Main.isLegacy()) {
                BlockData blockData = ladder.getBlockData();
                if (blockData instanceof Directional) {
                    ((Directional)blockData).setFacing(ladderFace);
                    ladder.setBlockData(blockData);
                }
            } else {
                Reflect.getMethod((Object)ladder, "setData", Byte.TYPE).invoke(faceToByte.get(ladderFace));
            }
            Objects.requireNonNull(loc.getWorld()).playSound(loc, Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
        }
    }

    public void placeBlock(Location loc, Material mat) {
        if (!this.isLocationSafe(loc)) {
            return;
        }
        if (this.game.getStatus() != GameStatus.RUNNING) {
            return;
        }
        this.game.getRegion().removeBlockBuiltDuringGame(loc);
        loc.getBlock().setType(mat);
        this.game.getRegion().addBuiltDuringGame(loc);
        loc.getWorld().playSound(loc, Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
    }

    public boolean isLocationSafe(Location location) {
        Block locBlock = location.getBlock();
        return (locBlock.getType() == Material.AIR || Main.isBreakableBlock((Material)location.getBlock().getType()) || this.game.getRegion().isBlockAddedDuringGame(location)) && !this.isTargetBlockNear(this.targetBlocks, location) && !this.isEntranceLocation(location);
    }

    public boolean isEntranceLocation(Location toCheck) {
        return this.enterancelocation.contains(toCheck);
    }

    public Game getGame() {
        return this.game;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Location getCenterPoint() {
        return this.centerPoint;
    }

    public BlockFace getPlacementFace() {
        return this.placementFace;
    }

    public List<Location> getEnterancelocation() {
        return this.enterancelocation;
    }

    public List<Location> getTargetBlocks() {
        return this.targetBlocks;
    }

    public void setTargetBlocks(List<Location> targetBlocks) {
        this.targetBlocks = targetBlocks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopupTower)) {
            return false;
        }
        PopupTower other = (PopupTower)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !this$game.equals(other$game)) {
            return false;
        }
        Material this$material = this.getMaterial();
        Material other$material = other.getMaterial();
        if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
            return false;
        }
        Location this$centerPoint = this.getCenterPoint();
        Location other$centerPoint = other.getCenterPoint();
        if (this$centerPoint == null ? other$centerPoint != null : !this$centerPoint.equals(other$centerPoint)) {
            return false;
        }
        BlockFace this$placementFace = this.getPlacementFace();
        BlockFace other$placementFace = other.getPlacementFace();
        if (this$placementFace == null ? other$placementFace != null : !this$placementFace.equals(other$placementFace)) {
            return false;
        }
        List<Location> this$enterancelocation = this.getEnterancelocation();
        List<Location> other$enterancelocation = other.getEnterancelocation();
        if (this$enterancelocation == null ? other$enterancelocation != null : !((Object)this$enterancelocation).equals(other$enterancelocation)) {
            return false;
        }
        List<Location> this$targetBlocks = this.getTargetBlocks();
        List<Location> other$targetBlocks = other.getTargetBlocks();
        return !(this$targetBlocks == null ? other$targetBlocks != null : !((Object)this$targetBlocks).equals(other$targetBlocks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PopupTower;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : $game.hashCode());
        Material $material = this.getMaterial();
        result = result * 59 + ($material == null ? 43 : $material.hashCode());
        Location $centerPoint = this.getCenterPoint();
        result = result * 59 + ($centerPoint == null ? 43 : $centerPoint.hashCode());
        BlockFace $placementFace = this.getPlacementFace();
        result = result * 59 + ($placementFace == null ? 43 : $placementFace.hashCode());
        List<Location> $enterancelocation = this.getEnterancelocation();
        result = result * 59 + ($enterancelocation == null ? 43 : ((Object)$enterancelocation).hashCode());
        List<Location> $targetBlocks = this.getTargetBlocks();
        result = result * 59 + ($targetBlocks == null ? 43 : ((Object)$targetBlocks).hashCode());
        return result;
    }

    public String toString() {
        return "PopupTower(game=" + this.getGame() + ", material=" + this.getMaterial() + ", centerPoint=" + this.getCenterPoint() + ", placementFace=" + this.getPlacementFace() + ", enterancelocation=" + this.getEnterancelocation() + ", targetBlocks=" + this.getTargetBlocks() + ")";
    }

    public PopupTower(Game game, Material material, Location centerPoint, BlockFace placementFace) {
        this.game = game;
        this.material = material;
        this.centerPoint = centerPoint;
        this.placementFace = placementFace;
    }
}

