/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.specials.listener;

import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.specials.PopupTower;
import io.github.pronze.sba.utils.SBAUtil;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.APIUtils;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.TeamColor;

@Service
public class PopupTowerListener
implements Listener {
    private static final String POPUP_TOWER_PREFIX = "Module:PopupTower:";

    @OnPostEnable
    public void onPostEnable() {
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onTowerRegistration(BedwarsApplyPropertyToBoughtItem event) {
        if (event.getPropertyName().equalsIgnoreCase("PopupTower")) {
            ItemStack stack = event.getStack();
            APIUtils.hashIntoInvisibleString((ItemStack)stack, (String)this.applyProperty(event));
        }
    }

    @EventHandler
    public void onPopupTowerUse(PlayerInteractEvent event) {
        ItemStack stack;
        String unhidden;
        Player player = event.getPlayer();
        if (!Main.isPlayerInGame((Player)player)) {
            return;
        }
        GamePlayer gamePlayer = Main.getPlayerGameProfile((Player)player);
        org.screamingsandals.bedwars.game.Game game = gamePlayer.getGame();
        if (!(event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK || game.getStatus() != GameStatus.RUNNING || gamePlayer.isSpectator || event.getItem() == null || (unhidden = APIUtils.unhashFromInvisibleStringStartsWith((ItemStack)(stack = event.getItem()), (String)POPUP_TOWER_PREFIX)) == null)) {
            event.setCancelled(true);
            stack.setAmount(stack.getAmount() - 1);
            player.updateInventory();
            RunningTeam team = game.getTeamOfPlayer(player);
            BlockFace playerFace = SBAUtil.yawToFace(player.getLocation().getYaw(), false);
            PopupTower tower = new PopupTower((Game)game, TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).getWool().getType(), player.getLocation().getBlock().getRelative(playerFace).getRelative(BlockFace.DOWN).getLocation(), playerFace);
            tower.createTower();
        }
    }

    private String applyProperty(BedwarsApplyPropertyToBoughtItem event) {
        return POPUP_TOWER_PREFIX;
    }
}

