/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.specials.runners;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.utils.SBAUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.utils.Sounds;

public class BridgeEggRunnable
extends BukkitRunnable {
    private final BukkitTask task;
    private final Egg egg;
    private final Player thrower;
    private final Game game;
    private final RunningTeam team;
    private final Material wool;

    public BridgeEggRunnable(Egg egg, RunningTeam team, Player thrower, Game game) {
        this.egg = egg;
        this.team = team;
        this.thrower = thrower;
        this.game = game;
        this.wool = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).getWool().getType();
        this.task = this.runTaskTimer((Plugin)SBA.getPluginInstance(), 0L, 1L);
    }

    public void run() {
        Location eggLocation = this.egg.getLocation();
        if (!Main.getInstance().isPlayerPlayingAnyGame(this.thrower) || this.egg.isDead() || this.team.isDead() || this.game.getStatus() != GameStatus.RUNNING) {
            this.cancel();
            return;
        }
        if (eggLocation.distance(this.thrower.getLocation()) > 30.0) {
            this.cancel();
            return;
        }
        Block b1 = eggLocation.clone().subtract(0.0, 3.0, 0.0).getBlock();
        this.setBlock(b1);
        Block b2 = eggLocation.clone().subtract(1.0, 3.0, 0.0).getBlock();
        this.setBlock(b2);
        Block b3 = eggLocation.clone().subtract(0.0, 3.0, 1.0).getBlock();
        this.setBlock(b3);
    }

    public void setBlock(Block block) {
        if (block.getType() == Material.AIR) {
            block.setType(this.wool);
            this.game.getRegion().addBuiltDuringGame(block.getLocation());
            Sounds.playSound((Location)block.getLocation(), (String)"ENTITY_CHICKEN_EGG", (Sounds)Sounds.ENTITY_CHICKEN_EGG, (float)1.0f, (float)1.0f);
        }
    }

    public void cancel() {
        SBAUtil.cancelTask(this.task);
    }

    public BukkitTask getTask() {
        return this.task;
    }
}

