/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentMapping;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.simpleinventories.builder.LocalOptionsBuilder;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Price;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.DegradableItem;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.StoreType;
import io.github.pronze.sba.inventories.SBAUpgradeStoreInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.TeamColor;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.api.utils.ColorChanger;

public class ShopUtil {
    public static final List<String> romanNumerals = List.of("NONE", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X");
    public static final List<String> orderOfArmor = List.of("GOLDEN,GOLD", "CHAINMAIL", "IRON", "DIAMOND", "NETHERITE");
    public static final List<String> orderOfTools = List.of("WOODEN,WOOD", "STONE", "GOLDEN,GOLD", "IRON", "DIAMOND");

    @NotNull
    public static Integer getLevelFromMaterialName(@NotNull String name, List<String> list) {
        @NotNull String finalName = name = name.substring(0, name.contains("_") ? name.lastIndexOf("_") : name.length());
        return list.stream().filter(value -> Arrays.stream(value.split(",")).anyMatch(names -> names.equalsIgnoreCase(finalName))).map(list::indexOf).findAny().orElse(0);
    }

    @NotNull
    public static String getMaterialFromLevel(int level, DegradableItem itemType) {
        String[] toParse;
        List<String> list = itemType == DegradableItem.ARMOR ? orderOfArmor : orderOfTools;
        String obj = list.get(level);
        if (obj == null) {
            obj = list.get(0);
        }
        String toTest = itemType == DegradableItem.ARMOR ? "_BOOTS" : "_AXE";
        for (String matName : toParse = obj.split(",")) {
            try {
                Material.valueOf((String)(matName + toTest));
                return matName;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return list.get(0);
    }

    @NotNull
    public static String getMaterialFromArmorOrTools(@NotNull String material) {
        return material.substring(0, material.indexOf("_")).toUpperCase();
    }

    @NotNull
    public static String getMaterialFromArmorOrTools(@NotNull Material material) {
        return ShopUtil.getMaterialFromArmorOrTools(material.name());
    }

    public static boolean buyArmor(Player player, Material mat_boots, IGameStorage gameStorage, Game game) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack playerBoots = playerInventory.getBoots();
        String matName = ShopUtil.getMaterialFromArmorOrTools(mat_boots);
        if (playerBoots != null) {
            Material currentMat = playerBoots.getType();
            String currentMatName = ShopUtil.getMaterialFromArmorOrTools(currentMat);
            int currentLevel = ShopUtil.getLevelFromMaterialName(currentMatName, orderOfArmor);
            int newLevel = ShopUtil.getLevelFromMaterialName(matName, orderOfArmor);
            if (!SBAConfig.getInstance().node("can-downgrade-item").getBoolean(false) && currentLevel > newLevel) {
                LanguageService.getInstance().get(MessageKeys.CANNOT_DOWNGRADE_ITEM).replace("%item%", "armor").send(PlayerMapper.wrapPlayer(player));
                return false;
            }
            if (currentLevel == newLevel) {
                LanguageService.getInstance().get(MessageKeys.ALREADY_PURCHASED).replace("%thing%", "armor").send(PlayerMapper.wrapPlayer(player));
                return false;
            }
        }
        ItemStack boots = new ItemStack(mat_boots);
        ItemStack leggings = new ItemStack(Material.valueOf((String)(matName + "_LEGGINGS")));
        ItemStack chestplate = new ItemStack(Material.valueOf((String)(matName + "_CHESTPLATE")));
        Integer level = gameStorage.getProtectionLevel(game.getTeamOfPlayer(player)).orElseThrow();
        if (level != 0) {
            boots.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, level.intValue());
            leggings.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, level.intValue());
        }
        playerInventory.setLeggings(null);
        playerInventory.setBoots(null);
        playerInventory.setBoots(boots);
        if (SBAConfig.getInstance().node("upgrade-item", "leggings").getBoolean(true)) {
            playerInventory.setLeggings(leggings);
        }
        if (SBAConfig.getInstance().node("upgrade-item", "chestplate").getBoolean(true)) {
            playerInventory.setChestplate(chestplate);
        }
        return true;
    }

    static <K, V> List<K> getAllKeysForValue(Map<K, V> mapOfWords, V value) {
        return mapOfWords.entrySet().stream().filter(entry -> entry.getValue().equals(value)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <K, V> K getKey(Map<K, V> map, V value) {
        return map.keySet().stream().filter(key -> value.equals(map.get(key))).findAny().orElse(null);
    }

    public static void giveItemToPlayer(@NotNull List<ItemStack> itemStackList, Player player, TeamColor teamColor) {
        itemStackList.forEach(itemStack -> {
            if (itemStack == null) {
                return;
            }
            ColorChanger colorChanger = BedwarsAPI.getInstance().getColorChanger();
            String materialName = itemStack.getType().toString();
            PlayerInventory playerInventory = player.getInventory();
            if (materialName.contains("HELMET")) {
                playerInventory.setHelmet(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("CHESTPLATE")) {
                playerInventory.setChestplate(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("LEGGINGS")) {
                playerInventory.setLeggings(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("BOOTS")) {
                playerInventory.setBoots(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("PICKAXE")) {
                playerInventory.setItem(7, itemStack);
            } else if (materialName.contains("AXE")) {
                playerInventory.setItem(8, itemStack);
            } else if (materialName.contains("SWORD")) {
                playerInventory.setItem(0, itemStack);
            } else {
                playerInventory.addItem(new ItemStack[]{colorChanger.applyColor(teamColor, itemStack)});
            }
        });
    }

    public static ItemStack downgradeItem(ItemStack currentItem, DegradableItem itemType) {
        String currentItemName = ShopUtil.getMaterialFromArmorOrTools(currentItem.getType());
        int currentItemLevel = ShopUtil.getLevelFromMaterialName(currentItemName, orderOfTools);
        if (currentItemLevel == 0) {
            return currentItem;
        }
        int newItemLevel = currentItemLevel - 1;
        String newMaterialName = ShopUtil.getMaterialFromLevel(newItemLevel, itemType);
        Material newMaterial = Material.valueOf((String)(newMaterialName + currentItem.getType().name().substring(currentItem.getType().name().lastIndexOf("_")).toUpperCase()));
        ItemStack newStack = new ItemStack(newMaterial);
        newStack.addEnchantments(currentItem.getEnchantments());
        return newStack;
    }

    public static int getIntFromMode(String mode) {
        return mode.equalsIgnoreCase("Solo") ? 1 : (mode.equalsIgnoreCase("Double") ? 2 : (mode.equalsIgnoreCase("Triples") ? 3 : (mode.equalsIgnoreCase("Squads") ? 4 : 0)));
    }

    public static String translateColors(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static void sendMessage(Player player, List<String> message) {
        message.forEach(st -> player.sendMessage(ShopUtil.translateColors(st)));
    }

    public static File normalizeShopFile(String name) {
        if (name.split("\\.").length > 1) {
            return SBA.getPluginInstance().getDataFolder().toPath().resolve(name).toFile();
        }
        File fileg = SBA.getPluginInstance().getDataFolder().toPath().resolve(name + ".groovy").toFile();
        if (fileg.exists()) {
            return fileg;
        }
        return SBA.getPluginInstance().getDataFolder().toPath().resolve(name + ".yml").toFile();
    }

    public static Map<?, ?> nullValuesAllowingMap(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (Object object : objects) {
            if (key == null) {
                key = Objects.requireNonNull(object);
                continue;
            }
            map.put(key, object);
            key = null;
        }
        return map;
    }

    public static Item setLore(Item item, PlayerItemInfo itemInfo, String price, ItemSpawnerType type, Player player) {
        Boolean enabled = itemInfo.getFirstPropertyByName("generateLore").map(property -> property.getPropertyData().getBoolean()).orElseGet(() -> Main.getConfigurator().config.getBoolean("lore.generate-automatically", true));
        if (enabled.booleanValue()) {
            int limit;
            int currentLevel;
            List<Component> originalList = item.getLore();
            boolean isSharp = itemInfo.getFirstPropertyByName("sharpness").isPresent();
            boolean isProt = itemInfo.getFirstPropertyByName("protection").isPresent();
            boolean isEfficiency = itemInfo.getFirstPropertyByName("efficiency").isPresent();
            Game game = Main.getInstance().getGameOfPlayer(player);
            IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
            if (isSharp) {
                currentLevel = arena.getStorage().getSharpnessLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Sharpness").getInt(2);
                if (currentLevel <= limit) {
                    price = String.valueOf(SBAUpgradeStoreInventory.sharpnessPrices.get(arena.getStorage().getSharpnessLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1));
                }
            }
            if (isProt) {
                currentLevel = arena.getStorage().getProtectionLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Protection").getInt(4);
                if (currentLevel <= limit) {
                    price = String.valueOf(SBAUpgradeStoreInventory.protectionPrices.get(arena.getStorage().getProtectionLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1));
                }
            }
            if (isEfficiency) {
                currentLevel = arena.getStorage().getEfficiencyLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Efficiency").getInt(4);
                if (currentLevel <= limit) {
                    price = String.valueOf(SBAUpgradeStoreInventory.efficiencyPrices.get(arena.getStorage().getEfficiencyLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1));
                }
            }
            String finalPrice = price;
            ArrayList newList = itemInfo.getFirstPropertyByName("generatedLoreText").map(property -> property.getPropertyData().childrenList().stream().map(ConfigurationNode::getString)).orElseGet(() -> Main.getConfigurator().config.getStringList("lore.text").stream()).map(s -> s.replaceAll("%price%", finalPrice).replaceAll("%resource%", type.getItemName()).replaceAll("%amount%", Integer.toString(itemInfo.getStack().getAmount()))).map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).map(AdventureHelper::toComponent).collect(Collectors.toCollection(ArrayList::new));
            newList.addAll(originalList);
            return item.withItemLore(newList);
        }
        return item;
    }

    public static String getNameOrCustomNameOfItem(Item item) {
        try {
            if (item.getDisplayName() != null) {
                return AdventureHelper.toLegacy(item.getDisplayName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String normalItemName = item.getMaterial().platformName().replace("_", " ").toLowerCase();
        String[] sArray = normalItemName.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : sArray) {
            stringBuilder.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public static void addEnchantsToPlayerArmor(Player player, int newLevel) {
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null) continue;
            item.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, newLevel);
        }
    }

    public static Item clampOrApplyEnchants(Item item, int level, Enchantment enchantment, StoreType type, int maxLevel) {
        if (type == StoreType.UPGRADES) {
            ++level;
        }
        if (level > maxLevel) {
            if ((item = item.withItemLore(LanguageService.getInstance().get(MessageKeys.SHOP_MAX_ENCHANT).toComponentList())).getEnchantments() != null) {
                item.getEnchantments().clear();
            }
        } else if (level > 0) {
            item = item.withEnchantment(EnchantmentMapping.resolve(enchantment).orElseThrow().withLevel(level));
        }
        return item;
    }

    public static Item applyTeamUpgradeEnchantsToItem(Item item, ItemRenderEvent event, StoreType type) {
        Optional<IGameStorage> maybeStorage;
        Player player = event.getPlayer().as(Player.class);
        Game game = Main.getInstance().getGameOfPlayer(player);
        String typeName = item.getMaterial().platformName();
        RunningTeam runningTeam = game.getTeamOfPlayer(player);
        List<Price> prices = event.getInfo().getOriginal().getPrices();
        if (!prices.isEmpty()) {
            ArrayList<Component> lore = new ArrayList<Component>(item.getLore());
            lore.add(LanguageService.getInstance().get(MessageKeys.CLICK_TO_PURCHASE).toComponent());
            item = item.withItemLore(lore);
        }
        if ((maybeStorage = SBA.getInstance().getGameStorage(game)).isPresent()) {
            IGameStorage gameStorage = maybeStorage.get();
            String afterUnderscore = typeName.substring(typeName.contains("_") ? typeName.indexOf("_") + 1 : 0);
            switch (afterUnderscore.toLowerCase()) {
                case "sword": {
                    int sharpness = gameStorage.getSharpnessLevel(runningTeam).orElseThrow();
                    item = ShopUtil.clampOrApplyEnchants(item, sharpness, Enchantment.DAMAGE_ALL, type, SBAConfig.getInstance().node("upgrades", "limit", "Sharpness").getInt(1));
                    break;
                }
                case "chestplate": 
                case "boots": {
                    int protection = gameStorage.getProtectionLevel(runningTeam).orElseThrow();
                    item = ShopUtil.clampOrApplyEnchants(item, protection, Enchantment.PROTECTION_ENVIRONMENTAL, type, SBAConfig.getInstance().node("upgrades", "limit", "Protection").getInt(4));
                    break;
                }
                case "pickaxe": {
                    int efficiency = gameStorage.getEfficiencyLevel(runningTeam).orElseThrow();
                    item = ShopUtil.clampOrApplyEnchants(item, efficiency, Enchantment.DIG_SPEED, type, SBAConfig.getInstance().node("upgrades", "limit", "Efficiency").getInt(2));
                }
            }
        }
        return item;
    }

    public static void generateOptions(LocalOptionsBuilder localOptionsBuilder) {
        ItemStack backItem = Main.getConfigurator().readDefinedItem("shopback", "BARRIER");
        ItemMeta backItemMeta = backItem.getItemMeta();
        localOptionsBuilder.renderHeaderStart(600).renderFooterStart(600).renderOffset(9).rows(4).renderActualRows(4).showPageNumber(false);
    }

    public static String ChatColorChanger(Player player) {
        SBAPlayerWrapper db = PlayerWrapperService.getInstance().get(player).orElseThrow();
        if (db.getLevel() > 100 || player.isOp()) {
            return "\u00a7f";
        }
        return "\u00a77";
    }

    public static void applyTeamUpgrades(@NotNull Player player, Game game) {
        RunningTeam team = game.getTeamOfPlayer(player);
        IGameStorage gameStorage = ArenaManager.getInstance().get(game.getName()).orElseThrow().getStorage();
        Integer teamProtectionLevel = gameStorage.getProtectionLevel(team).orElse(0);
        if (teamProtectionLevel > 0) {
            ShopUtil.addEnchantsToPlayerArmor(player, teamProtectionLevel);
        }
        Integer finalTeamSharpnessLevel = gameStorage.getSharpnessLevel(team).orElse(0);
        Integer finalTeamEfficiencyLevel = gameStorage.getEfficiencyLevel(team).orElse(0);
        Logger.trace("Player teamProtectionLevel {}", teamProtectionLevel);
        Logger.trace("Player finalTeamSharpnessLevel {}", finalTeamSharpnessLevel);
        Logger.trace("Player finalTeamEfficiencyLevel {}", finalTeamEfficiencyLevel);
        Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> {
            if (finalTeamSharpnessLevel > 0 && item.getType().name().endsWith("SWORD")) {
                item.addEnchantment(Enchantment.DAMAGE_ALL, finalTeamSharpnessLevel.intValue());
            }
            if (finalTeamEfficiencyLevel > 0 && item.getType().name().endsWith("PICKAXE")) {
                item.addEnchantment(Enchantment.DIG_SPEED, finalTeamEfficiencyLevel.intValue());
            }
        });
    }
}

