/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.visuals;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.pronzelib.scoreboards.holder.ScoreboardHolder;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.DateUtils;
import io.github.pronze.sba.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.TeamColor;

@Service
public class LobbyScoreboardManager
implements Listener {
    private final Map<UUID, Scoreboard> scoreboardMap = new HashMap<UUID, Scoreboard>();

    public static LobbyScoreboardManager getInstance() {
        return ServiceManager.get(LobbyScoreboardManager.class);
    }

    @OnPostEnable
    public void registerListener() {
        if (!SBAConfig.getInstance().node("lobby-scoreboard", "enabled").getBoolean(true)) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler
    public void onPlayerJoin(BedwarsPlayerJoinedEvent e) {
        Player player = e.getPlayer();
        if (e.getGame().getStatus() == GameStatus.WAITING) {
            Bukkit.getScheduler().runTaskLater((Plugin)SBA.getPluginInstance(), () -> this.createBoard(player, e.getGame()), 3L);
        }
    }

    private void createBoard(Player player, Game game) {
        Logger.trace("Creating board for player: {}", player.getName());
        Optional<Scoreboard> scoreboardOptional = ScoreboardManager.getInstance().fromCache(player.getUniqueId());
        scoreboardOptional.ifPresent(Scoreboard::destroy);
        List<String> animatedTitle = LanguageService.getInstance().get(MessageKeys.ANIMATED_BEDWARS_TITLE).toStringList();
        Scoreboard scoreboard = Scoreboard.builder().animate(true).player(player).displayObjective("bwa-lobby").updateInterval(20L).animationInterval(2L).animatedTitle(animatedTitle).updateCallback(board -> {
            board.setLines(this.process(player, game, board));
            return true;
        }).build();
        this.scoreboardMap.put(player.getUniqueId(), scoreboard);
    }

    @EventHandler
    public void onPlayerLeave(BedwarsPlayerLeaveEvent e) {
        this.remove(e.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.remove(e.getPlayer());
    }

    private void remove(Player player) {
        Scoreboard scoreboard;
        if (this.scoreboardMap.containsKey(player.getUniqueId()) && (scoreboard = this.scoreboardMap.get(player.getUniqueId())) != null) {
            scoreboard.destroy();
            this.scoreboardMap.remove(player.getUniqueId());
        }
    }

    private List<String> process(Player player, Game game, Scoreboard scoreboard) {
        org.screamingsandals.bedwars.game.Game gameImpl;
        String time;
        String mode;
        ArrayList<String> lines = new ArrayList<String>();
        String state = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_STATE_WAITING).toString();
        int needplayers = game.getMinPlayers() - game.getConnectedPlayers().size();
        needplayers = Math.max(needplayers, 0);
        int s = ((org.screamingsandals.bedwars.api.Team)game.getAvailableTeams().get(0)).getMaxPlayers();
        if (game.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == 1)) {
            mode = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_SOLO_PREFIX).toString();
        } else if (game.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == 2)) {
            mode = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_DOUBLES_PREFIX).toString();
        } else if (game.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == 3)) {
            mode = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_TRIPLES_PREFIX).toString();
        } else if (game.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == 4)) {
            mode = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_SQUADS_PREFIX).toString();
        } else {
            List teamSize = game.getAvailableTeams().stream().map(m -> m.getMaxPlayers()).map(String::valueOf).collect(Collectors.toList());
            mode = String.join((CharSequence)"v", teamSize);
        }
        if (game.countConnectedPlayers() >= game.getMinPlayers() && game.getStatus() == GameStatus.WAITING && !(time = (gameImpl = (org.screamingsandals.bedwars.game.Game)game).getFormattedTimeLeft()).contains("0-1")) {
            String[] units = time.split(":");
            int seconds = Integer.parseInt(units[1]) + 1 + Integer.parseInt(units[0]) * 60;
            state = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_STATE).replace("%countdown%", seconds <= 60 ? String.valueOf(seconds) : gameImpl.getFormattedTimeLeft()).toString();
        }
        String finalState = state;
        int finalNeedplayers = needplayers;
        List<String> lobbyScoreboardLines = LanguageService.getInstance().get(MessageKeys.LOBBY_SCOREBOARD_LINES).toStringList();
        lobbyScoreboardLines.forEach(line -> {
            line = line.replace("%sba_version%", SBA.getInstance().getVersion()).replace("%date%", DateUtils.getFormattedDate()).replace("%state%", finalState).replace("%game%", game.getName()).replace("%players%", String.valueOf(game.getConnectedPlayers().size())).replace("%maxplayers%", String.valueOf(game.getMaxPlayers())).replace("%minplayers%", String.valueOf(game.getMinPlayers())).replace("%needplayers%", String.valueOf(finalNeedplayers)).replace("%mode%", mode);
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
            }
            lines.add((String)line);
        });
        ScoreboardHolder holder = scoreboard.getHolder();
        game.getRunningTeams().forEach(team -> {
            if (!holder.hasTeamEntry(team.getName())) {
                holder.addTeam(team.getName(), TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
            }
            Team scoreboardTeam = holder.getTeamOrRegister(team.getName());
            new HashSet(scoreboardTeam.getEntries()).stream().filter(Objects::nonNull).map(Bukkit::getPlayerExact).filter(Objects::nonNull).forEach(teamPlayer -> {
                if (!team.getConnectedPlayers().contains(teamPlayer)) {
                    scoreboardTeam.removeEntry(teamPlayer.getName());
                }
            });
            team.getConnectedPlayers().stream().map(OfflinePlayer::getName).filter(playerName -> !scoreboardTeam.hasEntry(playerName)).forEach(arg_0 -> ((Team)scoreboardTeam).addEntry(arg_0));
        });
        return lines;
    }
}

