/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.lib.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.lib.event.EventHandler;
import org.screamingsandals.lib.event.EventPriority;
import org.screamingsandals.lib.event.HandlerRegisteredEvent;
import org.screamingsandals.lib.event.HandlerUnregisteredEvent;
import org.screamingsandals.lib.event.SEvent;
import org.screamingsandals.lib.utils.Controllable;
import org.screamingsandals.lib.utils.ReceiverConsumer;
import org.screamingsandals.lib.utils.annotations.AbstractService;
import org.screamingsandals.lib.utils.executor.ExecutorProvider;

@AbstractService
public abstract class EventManager {
    private static ExecutorService executor;
    private static EventManager defaultEventManager;
    private final Map<Class<?>, List<EventHandler<? extends SEvent>>> handlers = new ConcurrentHashMap();
    private EventManager customManager;

    public EventManager(Controllable controllable) {
        controllable.enable(() -> {
            executor = ExecutorProvider.buildExecutor((String)"SEventManager");
        }).preDisable(this::destroy);
    }

    public static void init(Supplier<EventManager> supplier) {
        if (defaultEventManager != null) {
            throw new UnsupportedOperationException("Default EventManager has been already initialized!");
        }
        defaultEventManager = supplier.get();
    }

    public static <K extends SEvent> K fire(K event) {
        return defaultEventManager.fireEvent(event);
    }

    public static <K extends SEvent> CompletableFuture<K> fireAsync(K event) {
        return defaultEventManager.fireEventAsync(event);
    }

    public static EventManager createChildManager() {
        return new EventManager(){

            @Override
            public boolean isServerThread() {
                return defaultEventManager.isServerThread();
            }
        };
    }

    public static boolean isDefaultInitialized() {
        return defaultEventManager != null;
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, ReceiverConsumer<T> consumer) {
        return this.register(event, EventHandler.of(consumer));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, ReceiverConsumer<T> consumer, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, ReceiverConsumer<T> consumer, EventPriority eventPriority) {
        return this.register(event, EventHandler.of(consumer, eventPriority));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function, EventPriority eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, eventPriority, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, ReceiverConsumer<T> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, eventPriority, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, EventHandler<T> handler) {
        this.handlers.computeIfAbsent(event, e -> Collections.synchronizedList(new ArrayList())).add(handler);
        this.fireEvent(new HandlerRegisteredEvent(this, event, handler));
        return handler;
    }

    public <T extends SEvent> void unregister(EventHandler<T> handler) {
        this.handlers.forEach((key, value) -> {
            if (value.contains(handler)) {
                this.fireEvent(new HandlerUnregisteredEvent(this, (Class<?>)key, handler));
                value.remove(handler);
                if (value.isEmpty()) {
                    this.handlers.remove(key, value);
                }
            }
        });
    }

    public <K extends SEvent> K fireEvent(@NotNull K event) {
        EventPriority.VALUES.forEach(priority -> this.fireEvent(event, (EventPriority)((Object)priority)));
        return event;
    }

    public <K extends SEvent> K fireEvent(@NotNull K event, @NotNull EventPriority eventPriority) {
        if (event.isAsync() && this.isServerThread()) {
            throw new UnsupportedOperationException("Async event cannot be fired sync!");
        }
        this.findEventHandlers(event, eventPriority).forEach(eventHandler -> eventHandler.fire(event));
        if (this.customManager != null) {
            this.customManager.fireEvent(event, eventPriority);
        } else if (this != defaultEventManager) {
            defaultEventManager.fireEvent(event, eventPriority);
        }
        return event;
    }

    public <K extends SEvent> CompletableFuture<K> fireEventAsync(@NotNull K event) {
        LinkedList futures = new LinkedList();
        EventPriority.VALUES.forEach(priority -> futures.add(this.fireEventAsync(event, (EventPriority)((Object)priority))));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    public <K extends SEvent> CompletableFuture<K> fireEventAsync(@NotNull K event, @NotNull EventPriority eventPriority) {
        if (!event.isAsync()) {
            return CompletableFuture.completedFuture(this.fireEvent(event, eventPriority));
        }
        LinkedList futures = this.findEventHandlers(event, eventPriority).map(eventHandler -> {
            if (this.isServerThread()) {
                return CompletableFuture.runAsync(() -> eventHandler.fire(event), executor).exceptionally(ex -> {
                    throw new RuntimeException("Exception occurred while firing event!", (Throwable)ex);
                });
            }
            return CompletableFuture.completedFuture(this.fireEvent(event, eventPriority));
        }).collect(Collectors.toCollection(LinkedList::new));
        if (this.customManager != null) {
            futures.add(this.customManager.fireEventAsync(event, eventPriority).thenApply(ignored -> null));
        } else if (this != defaultEventManager) {
            futures.add(defaultEventManager.fireEventAsync(event, eventPriority).thenApply(ignored -> null));
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(event);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    public void unregisterAll() {
        this.handlers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).forEach(this::unregister);
    }

    public void drop() {
        this.handlers.clear();
    }

    public void setCustomManager(EventManager parent) {
        if (this != defaultEventManager) {
            this.customManager = parent;
        }
    }

    public boolean isRegistered(EventHandler<?> eventHandler) {
        return this.handlers.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).contains(eventHandler));
    }

    public void cloneEventManager(EventManager originalEventManager) {
        originalEventManager.handlers.forEach((key, value) -> value.forEach(entry1 -> this.register((Class)key, (EventHandler)entry1)));
    }

    public void destroy() {
        this.handlers.clear();
        if (this == defaultEventManager) {
            ExecutorProvider.destroyExecutor((ExecutorService)executor);
        }
    }

    private <E extends SEvent> Stream<? extends EventHandler<? extends SEvent>> findEventHandlers(E event, EventPriority priority) {
        return this.handlers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(event)).map(Map.Entry::getValue).flatMap(Collection::stream).filter(eventHandler -> eventHandler.getEventPriority() == priority);
    }

    public abstract boolean isServerThread();

    public EventManager() {
    }

    public static EventManager getDefaultEventManager() {
        return defaultEventManager;
    }

    public EventManager getCustomManager() {
        return this.customManager;
    }
}

