/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.lib.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.lib.plugin.PluginDescription;
import org.screamingsandals.lib.utils.Wrapper;
import org.screamingsandals.lib.utils.annotations.methods.OnDisable;
import org.screamingsandals.lib.utils.annotations.methods.OnEnable;
import org.screamingsandals.lib.utils.annotations.methods.OnPostEnable;
import org.screamingsandals.lib.utils.logger.LoggerWrapper;
import org.slf4j.Logger;

public abstract class PluginContainer
implements Wrapper {
    private PluginDescription pluginDescription;
    private LoggerWrapper logger;

    @ApiStatus.Internal
    public void init(@NotNull PluginDescription pluginDescription, LoggerWrapper logger) {
        if (this.pluginDescription != null) {
            throw new UnsupportedOperationException(pluginDescription.getName() + " is already initialized!");
        }
        this.pluginDescription = pluginDescription;
        this.logger = logger;
    }

    public void saveResource(@NotNull String resourcePath, boolean replace) {
        if (resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        resourcePath = resourcePath.replace('\\', '/');
        InputStream in = this.getClass().getResourceAsStream("/" + resourcePath);
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in classpath");
        }
        File outFile = this.pluginDescription.getDataFolder().resolve(resourcePath).toFile();
        File outDir = outFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                in.close();
            } else {
                this.getLogger().warn("Could not save " + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists.");
            }
        }
        catch (IOException ex) {
            this.getLogger().error("Could not save " + outFile.getName() + " to " + outFile, (Throwable)ex);
        }
    }

    public Path getDataFolder() {
        return this.getPluginDescription().getDataFolder();
    }

    @ApiStatus.Experimental
    public Logger getSLF4JLogger() {
        return (Logger)this.logger.as(Logger.class);
    }

    public <T> T as(Class<T> type) {
        return this.getPluginDescription().as(type);
    }

    public void load() {
    }

    @OnEnable
    @ApiStatus.OverrideOnly
    public void enable() {
    }

    @OnPostEnable
    @ApiStatus.OverrideOnly
    public void postEnable() {
    }

    @OnPostEnable
    @ApiStatus.OverrideOnly
    public void preDisable() {
    }

    @OnDisable
    @ApiStatus.OverrideOnly
    public void disable() {
    }

    public PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public LoggerWrapper getLogger() {
        return this.logger;
    }
}

