/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.lib.sender;

import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.lib.sender.CommandSenderWrapper;
import org.screamingsandals.lib.sender.SenderMessage;
import org.screamingsandals.lib.sender.TitleableSenderMessage;
import org.screamingsandals.lib.utils.AdventureHelper;

public interface SForwardingAudience
extends ForwardingAudience {
    @ApiStatus.OverrideOnly
    @NotNull
    public Iterable<CommandSenderWrapper> audiences();

    default public void sendMessage(String message) {
        this.sendMessage((Component)AdventureHelper.toComponent((String)message));
    }

    default public void sendMessage(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendMessage(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendActionBar(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendActionBar(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListHeader(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListHeader(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListFooter(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListFooter(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListHeaderAndFooter(SenderMessage header, SenderMessage footer) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListHeaderAndFooter(header.asComponent((CommandSenderWrapper)senderWrapper), footer.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void showTitle(TitleableSenderMessage title) {
        this.audiences().forEach(senderWrapper -> this.showTitle(title.asTitle((CommandSenderWrapper)senderWrapper)));
    }

    default public void showTitle(TitleableSenderMessage title, Title.Times times) {
        this.audiences().forEach(senderWrapper -> this.showTitle(title.asTitle((CommandSenderWrapper)senderWrapper, times)));
    }
}

