/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.lib.tasker;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.screamingsandals.lib.tasker.TaskerImpl;
import org.screamingsandals.lib.tasker.TaskerTime;
import org.screamingsandals.lib.tasker.initializer.AbstractTaskInitializer;
import org.screamingsandals.lib.tasker.task.TaskBase;
import org.screamingsandals.lib.tasker.task.TaskState;
import org.screamingsandals.lib.tasker.task.TaskerTask;
import org.screamingsandals.lib.utils.annotations.ForwardToService;

@ForwardToService(value=AbstractTaskInitializer.class)
public interface Tasker {
    public static Tasker init(Supplier<AbstractTaskInitializer> taskInitializer) {
        if (TaskerImpl.instance != null) {
            throw new UnsupportedOperationException("Tasker is already initialized!");
        }
        TaskerImpl.instance = new TaskerImpl(taskInitializer.get());
        return TaskerImpl.instance;
    }

    public static TaskBuilder build(Runnable runnable) {
        return TaskerImpl.instance.build(runnable);
    }

    public static TaskBuilder build(Function<TaskBase, Runnable> runnable) {
        return TaskerImpl.instance.build(runnable);
    }

    public static Map<Integer, TaskerTask> getRunningTasks() {
        return TaskerImpl.instance.getRunningTasks();
    }

    public static void cancelAll() {
        TaskerImpl.instance.cancelAll();
    }

    public static void cancel(TaskerTask taskerTask) {
        TaskerImpl.instance.cancel(taskerTask);
    }

    public static boolean register(TaskerTask taskerTask) {
        return TaskerImpl.instance.register(taskerTask);
    }

    public static TaskState getState(TaskerTask taskerTask) {
        return TaskerImpl.instance.getState(taskerTask);
    }

    public static interface TaskBuilder {
        public TaskBuilder afterOneTick();

        public TaskBuilder async();

        public TaskBuilder delay(long var1, TaskerTime var3);

        public TaskBuilder repeat(long var1, TaskerTime var3);

        public TaskBuilder startEvent(Consumer<TaskerTask> var1);

        public TaskBuilder stopEvent(Consumer<TaskerTask> var1);

        public TaskerTask start();
    }
}

